/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.AbstractSecurityBuilder;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.JcaTemplate;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.Randoms;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SecretKeyBuilder;
import javax.crypto.SecretKey;

public class DefaultSecretKeyBuilder
extends AbstractSecurityBuilder<SecretKey, SecretKeyBuilder>
implements SecretKeyBuilder {
    protected final String JCA_NAME;
    protected final int BIT_LENGTH;

    public DefaultSecretKeyBuilder(String jcaName, int bitLength) {
        this.JCA_NAME = Assert.hasText(jcaName, "jcaName cannot be null or empty.");
        if (bitLength % 8 != 0) {
            String msg = "bitLength must be an even multiple of 8";
            throw new IllegalArgumentException(msg);
        }
        this.BIT_LENGTH = Assert.gt(bitLength, 0, "bitLength must be > 0");
        this.random(Randoms.secureRandom());
    }

    @Override
    public SecretKey build() {
        JcaTemplate template = new JcaTemplate(this.JCA_NAME, this.provider, this.random);
        return template.generateSecretKey(this.BIT_LENGTH);
    }
}

