/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.CheckedFunction;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.RequiredParameterReader;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.AbstractEcJwkFactory;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultEcPublicJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.ECCurve;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.JwkContext;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.EcPublicJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.InvalidKeyException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Map;

class EcPublicJwkFactory
extends AbstractEcJwkFactory<ECPublicKey, EcPublicJwk> {
    private static final String UNSUPPORTED_CURVE_MSG = "The specified ECKey curve does not match a JWA standard curve id.";
    static final EcPublicJwkFactory INSTANCE = new EcPublicJwkFactory();

    EcPublicJwkFactory() {
        super(ECPublicKey.class, DefaultEcPublicJwk.PARAMS);
    }

    protected static String keyContainsErrorMessage(String curveId) {
        Assert.hasText(curveId, "curveId cannot be null or empty.");
        String fmt = "ECPublicKey's ECPoint does not exist on elliptic curve '%s' and may not be used to create '%s' JWKs.";
        return String.format(fmt, curveId, curveId);
    }

    protected static String jwkContainsErrorMessage(String curveId, Map<String, ?> jwk) {
        Assert.hasText(curveId, "curveId cannot be null or empty.");
        String fmt = "EC JWK x,y coordinates do not exist on elliptic curve '%s'. This could be due simply to an incorrectly-created JWK or possibly an attempted Invalid Curve Attack (see https://safecurves.cr.yp.to/twist.html for more information).";
        return String.format(fmt, curveId, jwk);
    }

    protected static String getJwaIdByCurve(EllipticCurve curve) {
        ECCurve c = ECCurve.findByJcaCurve(curve);
        if (c == null) {
            throw new InvalidKeyException(UNSUPPORTED_CURVE_MSG);
        }
        return c.getId();
    }

    @Override
    protected EcPublicJwk createJwkFromKey(JwkContext<ECPublicKey> ctx) {
        ECPublicKey key = ctx.getKey();
        ECParameterSpec spec = key.getParams();
        EllipticCurve curve = spec.getCurve();
        ECPoint point = key.getW();
        String curveId = EcPublicJwkFactory.getJwaIdByCurve(curve);
        if (!ECCurve.contains(curve, point)) {
            String msg = EcPublicJwkFactory.keyContainsErrorMessage(curveId);
            throw new InvalidKeyException(msg);
        }
        ctx.put((ECPublicKey)((Object)DefaultEcPublicJwk.CRV.getId()), curveId);
        String x = EcPublicJwkFactory.toOctetString(curve, point.getAffineX());
        ctx.put((ECPublicKey)((Object)DefaultEcPublicJwk.X.getId()), x);
        String y = EcPublicJwkFactory.toOctetString(curve, point.getAffineY());
        ctx.put((ECPublicKey)((Object)DefaultEcPublicJwk.Y.getId()), y);
        return new DefaultEcPublicJwk(ctx);
    }

    @Override
    protected EcPublicJwk createJwkFromValues(JwkContext<ECPublicKey> ctx) {
        ECPoint point;
        RequiredParameterReader reader = new RequiredParameterReader(ctx);
        String curveId = reader.get(DefaultEcPublicJwk.CRV);
        BigInteger x = reader.get(DefaultEcPublicJwk.X);
        BigInteger y = reader.get(DefaultEcPublicJwk.Y);
        ECCurve curve = EcPublicJwkFactory.getCurveByJwaId(curveId);
        if (!curve.contains(point = new ECPoint(x, y))) {
            String msg = EcPublicJwkFactory.jwkContainsErrorMessage(curveId, ctx);
            throw new InvalidKeyException(msg);
        }
        final ECPublicKeySpec pubSpec = new ECPublicKeySpec(point, curve.toParameterSpec());
        ECPublicKey key = this.generateKey(ctx, new CheckedFunction<KeyFactory, ECPublicKey>(){

            @Override
            public ECPublicKey apply(KeyFactory kf) throws Exception {
                return (ECPublicKey)kf.generatePublic(pubSpec);
            }
        });
        ctx.setKey(key);
        return new DefaultEcPublicJwk(ctx);
    }
}

