/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.io.Streams;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Bytes;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.CheckedFunction;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.AesAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.AeadAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.AeadRequest;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.AeadResult;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.DecryptAeadRequest;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class GcmAesAeadAlgorithm
extends AesAlgorithm
implements AeadAlgorithm {
    private static final String TRANSFORMATION_STRING = "AES/GCM/NoPadding";

    public GcmAesAeadAlgorithm(int keyLength) {
        super("A" + keyLength + "GCM", TRANSFORMATION_STRING, keyLength);
    }

    @Override
    public void encrypt(AeadRequest req, AeadResult res) throws SecurityException {
        Assert.notNull(req, "Request cannot be null.");
        Assert.notNull(res, "Result cannot be null.");
        final SecretKey key = this.assertKey((SecretKey)req.getKey());
        final InputStream plaintext = (InputStream)Assert.notNull(req.getPayload(), "Request content (plaintext) InputStream cannot be null.");
        final OutputStream out = Assert.notNull(res.getOutputStream(), "Result ciphertext OutputStream cannot be null.");
        final InputStream aad = req.getAssociatedData();
        byte[] iv = this.ensureInitializationVector(req);
        final AlgorithmParameterSpec ivSpec = this.getIvSpec(iv);
        byte[] tag = this.jca(req).withCipher(new CheckedFunction<Cipher, byte[]>(){

            @Override
            public byte[] apply(Cipher cipher) throws Exception {
                cipher.init(1, (Key)key, ivSpec);
                byte[] taggedCiphertext = GcmAesAeadAlgorithm.this.withCipher(cipher, plaintext, aad, out);
                int ciphertextLength = Bytes.length(taggedCiphertext) - 16;
                Streams.write(out, taggedCiphertext, 0, ciphertextLength, "Ciphertext write failure.");
                byte[] tag = new byte[16];
                System.arraycopy(taggedCiphertext, ciphertextLength, tag, 0, 16);
                return tag;
            }
        });
        Streams.flush(out);
        Streams.reset(plaintext);
        res.setTag(tag).setIv(iv);
    }

    @Override
    public void decrypt(DecryptAeadRequest req, final OutputStream out) throws SecurityException {
        Assert.notNull(req, "Request cannot be null.");
        Assert.notNull(out, "Plaintext OutputStream cannot be null.");
        final SecretKey key = this.assertKey((SecretKey)req.getKey());
        InputStream ciphertext = (InputStream)Assert.notNull(req.getPayload(), "Decryption request content (ciphertext) InputStream cannot be null.");
        final InputStream aad = req.getAssociatedData();
        byte[] tag = Assert.notEmpty(req.getDigest(), "Decryption request authentication tag cannot be null or empty.");
        byte[] iv = this.assertDecryptionIv(req);
        final AlgorithmParameterSpec ivSpec = this.getIvSpec(iv);
        final SequenceInputStream taggedCiphertext = new SequenceInputStream(ciphertext, Streams.of(tag));
        this.jca(req).withCipher(new CheckedFunction<Cipher, byte[]>(){

            @Override
            public byte[] apply(Cipher cipher) throws Exception {
                cipher.init(2, (Key)key, ivSpec);
                byte[] last = GcmAesAeadAlgorithm.this.withCipher(cipher, taggedCiphertext, aad, out);
                Streams.write(out, last, "GcmAesAeadAlgorithm#decrypt plaintext write failure.");
                return Bytes.EMPTY;
            }
        });
        Streams.flush(out);
    }
}

