/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Bytes;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Converter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.JcaTemplate;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.io.Decoders;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.io.Encoders;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SecurityException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JwtX509StringConverter
implements Converter<X509Certificate, CharSequence> {
    public static final JwtX509StringConverter INSTANCE = new JwtX509StringConverter();

    @Override
    public String applyTo(X509Certificate cert) {
        byte[] der;
        Assert.notNull(cert, "X509Certificate cannot be null.");
        try {
            der = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            String msg = "Unable to access X509Certificate encoded bytes necessary to perform DER Base64-encoding. Certificate: {" + cert + "}. Cause: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
        if (Bytes.isEmpty(der)) {
            String msg = "X509Certificate encoded bytes cannot be null or empty.  Certificate: {" + cert + "}.";
            throw new IllegalArgumentException(msg);
        }
        return Encoders.BASE64.encode(der);
    }

    protected X509Certificate toCert(byte[] der) throws SecurityException {
        return new JcaTemplate("X.509").generateX509Certificate(der);
    }

    @Override
    public X509Certificate applyFrom(CharSequence s2) {
        Assert.hasText(s2, "X.509 Certificate encoded string cannot be null or empty.");
        try {
            byte[] der = Decoders.BASE64.decode(s2);
            return this.toCert(der);
        }
        catch (Exception e) {
            String msg = "Unable to convert Base64 String '" + s2 + "' to X509Certificate instance. Cause: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }
}

