/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SecureDigestAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SecureRequest;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SecurityException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SignatureException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.VerifySecureDigestRequest;
import java.io.InputStream;
import java.security.Key;

final class NoneSignatureAlgorithm
implements SecureDigestAlgorithm<Key, Key> {
    private static final String ID = "none";
    static final SecureDigestAlgorithm<Key, Key> INSTANCE = new NoneSignatureAlgorithm();

    private NoneSignatureAlgorithm() {
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public byte[] digest(SecureRequest<InputStream, Key> request) throws SecurityException {
        throw new SignatureException("The 'none' algorithm cannot be used to create signatures.");
    }

    @Override
    public boolean verify(VerifySecureDigestRequest<Key> request) throws SignatureException {
        throw new SignatureException("The 'none' algorithm cannot be used to verify signatures.");
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SecureDigestAlgorithm && ID.equalsIgnoreCase(((SecureDigestAlgorithm)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return ID;
    }
}

