/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.RequiredParameterReader;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultJwkContext;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultOctetPrivateJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultOctetPublicJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.EdwardsCurve;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.JwkContext;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.OctetJwkFactory;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.OctetPublicJwkFactory;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Strings;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.InvalidKeyException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.Jwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.OctetPrivateJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.OctetPublicJwk;
import java.security.PrivateKey;
import java.security.PublicKey;

public class OctetPrivateJwkFactory
extends OctetJwkFactory<PrivateKey, OctetPrivateJwk<PrivateKey, PublicKey>> {
    public OctetPrivateJwkFactory() {
        super(PrivateKey.class, DefaultOctetPrivateJwk.PARAMS);
    }

    @Override
    protected boolean supportsKeyValues(JwkContext<?> ctx) {
        return super.supportsKeyValues(ctx) && ctx.containsKey(DefaultOctetPrivateJwk.D.getId());
    }

    @Override
    protected OctetPrivateJwk<PrivateKey, PublicKey> createJwkFromKey(JwkContext<PrivateKey> ctx) {
        PrivateKey key = Assert.notNull(ctx.getKey(), "PrivateKey cannot be null.");
        EdwardsCurve crv = EdwardsCurve.forKey(key);
        PublicKey pub = ctx.getPublicKey();
        if (pub != null) {
            if (!crv.equals(EdwardsCurve.forKey(pub))) {
                String msg = "Specified Edwards Curve PublicKey does not match the specified PrivateKey's curve.";
                throw new InvalidKeyException(msg);
            }
        } else {
            pub = EdwardsCurve.derivePublic(key);
        }
        boolean copyId = !Strings.hasText(ctx.getId()) && ctx.getIdThumbprintAlgorithm() != null;
        JwkContext pubCtx = OctetPublicJwkFactory.INSTANCE.newContext((JwkContext)ctx, pub);
        OctetPublicJwk pubJwk = (OctetPublicJwk)OctetPublicJwkFactory.INSTANCE.createJwk(pubCtx);
        ctx.putAll(pubJwk);
        if (copyId) {
            ctx.setId(pubJwk.getId());
        }
        byte[] d = crv.getKeyMaterial(key);
        Assert.notEmpty(d, "Edwards PrivateKey 'd' value cannot be null or empty.");
        OctetPrivateJwkFactory.put(ctx, DefaultOctetPrivateJwk.D, d);
        return new DefaultOctetPrivateJwk<PrivateKey, PublicKey>(ctx, pubJwk);
    }

    @Override
    protected OctetPrivateJwk<PrivateKey, PublicKey> createJwkFromValues(JwkContext<PrivateKey> ctx) {
        RequiredParameterReader reader = new RequiredParameterReader(ctx);
        EdwardsCurve curve = OctetPrivateJwkFactory.getCurve(reader);
        DefaultJwkContext pubCtx = new DefaultJwkContext(DefaultOctetPublicJwk.PARAMS, ctx);
        Jwk pubJwk = OctetPublicJwkFactory.INSTANCE.createJwkFromValues((JwkContext)pubCtx);
        byte[] d = reader.get(DefaultOctetPrivateJwk.D);
        PrivateKey key = curve.toPrivateKey(d, ctx.getProvider());
        ctx.setKey(key);
        return new DefaultOctetPrivateJwk<PrivateKey, PublicKey>(ctx, (OctetPublicJwk<PublicKey>)pubJwk);
    }
}

