/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.CheckedFunction;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Parameter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.RequiredParameterReader;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.AbstractFamilyJwkFactory;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultJwkContext;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultRsaPrivateJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultRsaPublicJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.JwkContext;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.KeysBridge;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.RsaPublicJwkFactory;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Arrays;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Collections;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Strings;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.InvalidKeyException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.Jwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.RsaPrivateJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.RsaPublicJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.UnsupportedKeyException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.RSAMultiPrimePrivateCrtKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.security.spec.RSAMultiPrimePrivateCrtKeySpec;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.List;
import java.util.Set;

class RsaPrivateJwkFactory
extends AbstractFamilyJwkFactory<RSAPrivateKey, RsaPrivateJwk> {
    private static final Set<Parameter<BigInteger>> OPTIONAL_PRIVATE_PARAMS = Collections.setOf(DefaultRsaPrivateJwk.FIRST_PRIME, DefaultRsaPrivateJwk.SECOND_PRIME, DefaultRsaPrivateJwk.FIRST_CRT_EXPONENT, DefaultRsaPrivateJwk.SECOND_CRT_EXPONENT, DefaultRsaPrivateJwk.FIRST_CRT_COEFFICIENT);
    private static final String PUBKEY_ERR_MSG = "JwkContext publicKey must be an " + RSAPublicKey.class.getName() + " instance.";
    private static final String PUB_EXPONENT_EX_MSG = "Unable to derive RSAPublicKey from RSAPrivateKey [%s]. Supported keys implement the " + RSAPrivateCrtKey.class.getName() + " or " + RSAMultiPrimePrivateCrtKey.class.getName() + " interfaces.  If the specified RSAPrivateKey cannot be one of these two, you must explicitly " + "provide an RSAPublicKey in addition to the RSAPrivateKey, as the " + "[JWA RFC, Section 6.3.2](https://www.rfc-editor.org/rfc/rfc7518.html#section-6.3.2) " + "requires public values to be present in private RSA JWKs.";

    RsaPrivateJwkFactory() {
        super("RSA", RSAPrivateKey.class, DefaultRsaPrivateJwk.PARAMS);
    }

    @Override
    protected boolean supportsKeyValues(JwkContext<?> ctx) {
        return super.supportsKeyValues(ctx) && ctx.containsKey(DefaultRsaPrivateJwk.PRIVATE_EXPONENT.getId());
    }

    private static BigInteger getPublicExponent(RSAPrivateKey key) {
        if (key instanceof RSAPrivateCrtKey) {
            return ((RSAPrivateCrtKey)key).getPublicExponent();
        }
        if (key instanceof RSAMultiPrimePrivateCrtKey) {
            return ((RSAMultiPrimePrivateCrtKey)key).getPublicExponent();
        }
        String msg = String.format(PUB_EXPONENT_EX_MSG, KeysBridge.toString(key));
        throw new UnsupportedKeyException(msg);
    }

    private RSAPublicKey derivePublic(final JwkContext<RSAPrivateKey> ctx) {
        RSAPrivateKey key = ctx.getKey();
        BigInteger modulus = key.getModulus();
        BigInteger publicExponent = RsaPrivateJwkFactory.getPublicExponent(key);
        final RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, publicExponent);
        return this.generateKey(ctx, RSAPublicKey.class, new CheckedFunction<KeyFactory, RSAPublicKey>(){

            @Override
            public RSAPublicKey apply(KeyFactory kf) {
                try {
                    return (RSAPublicKey)kf.generatePublic(spec);
                }
                catch (Exception e) {
                    String msg = "Unable to derive RSAPublicKey from RSAPrivateKey " + ctx + ". Cause: " + e.getMessage();
                    throw new InvalidKeyException(msg);
                }
            }
        });
    }

    @Override
    protected RsaPrivateJwk createJwkFromKey(JwkContext<RSAPrivateKey> ctx) {
        RSAPrivateKey key = ctx.getKey();
        PublicKey publicKey = ctx.getPublicKey();
        RSAPublicKey rsaPublicKey = publicKey != null ? Assert.isInstanceOf(RSAPublicKey.class, publicKey, PUBKEY_ERR_MSG) : this.derivePublic(ctx);
        boolean copyId = !Strings.hasText(ctx.getId()) && ctx.getIdThumbprintAlgorithm() != null;
        JwkContext<RSAPublicKey> pubCtx = RsaPublicJwkFactory.INSTANCE.newContext(ctx, rsaPublicKey);
        RsaPublicJwk pubJwk = (RsaPublicJwk)RsaPublicJwkFactory.INSTANCE.createJwk(pubCtx);
        ctx.putAll(pubJwk);
        if (copyId) {
            ctx.setId(pubJwk.getId());
        }
        RsaPrivateJwkFactory.put(ctx, DefaultRsaPrivateJwk.PRIVATE_EXPONENT, key.getPrivateExponent());
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey ckey = (RSAPrivateCrtKey)key;
            RsaPrivateJwkFactory.put(ctx, DefaultRsaPrivateJwk.FIRST_PRIME, ckey.getPrimeP());
            RsaPrivateJwkFactory.put(ctx, DefaultRsaPrivateJwk.SECOND_PRIME, ckey.getPrimeQ());
            RsaPrivateJwkFactory.put(ctx, DefaultRsaPrivateJwk.FIRST_CRT_EXPONENT, ckey.getPrimeExponentP());
            RsaPrivateJwkFactory.put(ctx, DefaultRsaPrivateJwk.SECOND_CRT_EXPONENT, ckey.getPrimeExponentQ());
            RsaPrivateJwkFactory.put(ctx, DefaultRsaPrivateJwk.FIRST_CRT_COEFFICIENT, ckey.getCrtCoefficient());
        } else if (key instanceof RSAMultiPrimePrivateCrtKey) {
            RSAMultiPrimePrivateCrtKey ckey = (RSAMultiPrimePrivateCrtKey)key;
            RsaPrivateJwkFactory.put(ctx, DefaultRsaPrivateJwk.FIRST_PRIME, ckey.getPrimeP());
            RsaPrivateJwkFactory.put(ctx, DefaultRsaPrivateJwk.SECOND_PRIME, ckey.getPrimeQ());
            RsaPrivateJwkFactory.put(ctx, DefaultRsaPrivateJwk.FIRST_CRT_EXPONENT, ckey.getPrimeExponentP());
            RsaPrivateJwkFactory.put(ctx, DefaultRsaPrivateJwk.SECOND_CRT_EXPONENT, ckey.getPrimeExponentQ());
            RsaPrivateJwkFactory.put(ctx, DefaultRsaPrivateJwk.FIRST_CRT_COEFFICIENT, ckey.getCrtCoefficient());
            List<RSAOtherPrimeInfo> infos = Arrays.asList(ckey.getOtherPrimeInfo());
            if (!Collections.isEmpty(infos)) {
                RsaPrivateJwkFactory.put(ctx, DefaultRsaPrivateJwk.OTHER_PRIMES_INFO, infos);
            }
        }
        return new DefaultRsaPrivateJwk(ctx, pubJwk);
    }

    @Override
    protected RsaPrivateJwk createJwkFromValues(JwkContext<RSAPrivateKey> ctx) {
        RSAPrivateKeySpec spec;
        RequiredParameterReader reader = new RequiredParameterReader(ctx);
        BigInteger privateExponent = reader.get(DefaultRsaPrivateJwk.PRIVATE_EXPONENT);
        DefaultJwkContext pubCtx = new DefaultJwkContext(DefaultRsaPublicJwk.PARAMS, ctx);
        Jwk pubJwk = RsaPublicJwkFactory.INSTANCE.createJwkFromValues((JwkContext)pubCtx);
        RSAPublicKey pubKey = (RSAPublicKey)pubJwk.toKey();
        BigInteger modulus = pubKey.getModulus();
        BigInteger publicExponent = pubKey.getPublicExponent();
        boolean containsOptional = false;
        for (Parameter<BigInteger> param : OPTIONAL_PRIVATE_PARAMS) {
            if (!ctx.containsKey(param.getId())) continue;
            containsOptional = true;
            break;
        }
        if (containsOptional) {
            BigInteger firstPrime = reader.get(DefaultRsaPrivateJwk.FIRST_PRIME);
            BigInteger secondPrime = reader.get(DefaultRsaPrivateJwk.SECOND_PRIME);
            BigInteger firstCrtExponent = reader.get(DefaultRsaPrivateJwk.FIRST_CRT_EXPONENT);
            BigInteger secondCrtExponent = reader.get(DefaultRsaPrivateJwk.SECOND_CRT_EXPONENT);
            BigInteger firstCrtCoefficient = reader.get(DefaultRsaPrivateJwk.FIRST_CRT_COEFFICIENT);
            if (ctx.containsKey(DefaultRsaPrivateJwk.OTHER_PRIMES_INFO.getId())) {
                List<RSAOtherPrimeInfo> otherPrimes = reader.get(DefaultRsaPrivateJwk.OTHER_PRIMES_INFO);
                RSAOtherPrimeInfo[] arr = new RSAOtherPrimeInfo[Collections.size(otherPrimes)];
                arr = otherPrimes.toArray(arr);
                spec = new RSAMultiPrimePrivateCrtKeySpec(modulus, publicExponent, privateExponent, firstPrime, secondPrime, firstCrtExponent, secondCrtExponent, firstCrtCoefficient, arr);
            } else {
                spec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, firstPrime, secondPrime, firstCrtExponent, secondCrtExponent, firstCrtCoefficient);
            }
        } else {
            spec = new RSAPrivateKeySpec(modulus, privateExponent);
        }
        RSAPrivateKey key = this.generateFromSpec(ctx, spec);
        ctx.setKey(key);
        return new DefaultRsaPrivateJwk(ctx, (RsaPublicJwk)pubJwk);
    }

    protected RSAPrivateKey generateFromSpec(JwkContext<RSAPrivateKey> ctx, final KeySpec keySpec) {
        return this.generateKey(ctx, new CheckedFunction<KeyFactory, RSAPrivateKey>(){

            @Override
            public RSAPrivateKey apply(KeyFactory kf) throws Exception {
                return (RSAPrivateKey)kf.generatePrivate(keySpec);
            }
        });
    }
}

