/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.Identifiable;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.Jwts;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Bytes;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.RequiredParameterReader;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.AbstractFamilyJwkFactory;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.AbstractJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.AesAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.CryptoAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultMacAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultSecretJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.JwkContext;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.KeysBridge;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.io.Encoders;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Strings;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.AeadAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.InvalidKeyException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.Keys;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.MacAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.MalformedKeyException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SecretJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SecretKeyAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.WeakKeyException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class SecretJwkFactory
extends AbstractFamilyJwkFactory<SecretKey, SecretJwk> {
    SecretJwkFactory() {
        super("oct", SecretKey.class, DefaultSecretJwk.PARAMS);
    }

    @Override
    protected SecretJwk createJwkFromKey(JwkContext<SecretKey> ctx) {
        String k;
        SecretKey key = Assert.notNull(ctx.getKey(), "JwkContext key cannot be null.");
        byte[] encoded = null;
        try {
            encoded = KeysBridge.getEncoded(key);
            k = Encoders.BASE64URL.encode(encoded);
            Assert.hasText(k, "k value cannot be null or empty.");
        }
        catch (Throwable t2) {
            String msg = "Unable to encode SecretKey to JWK: " + t2.getMessage();
            throw new InvalidKeyException(msg, t2);
        }
        finally {
            Bytes.clear(encoded);
        }
        DefaultMacAlgorithm mac = DefaultMacAlgorithm.findByKey(key);
        if (mac != null) {
            ctx.put((SecretKey)((Object)AbstractJwk.ALG.getId()), mac.getId());
        }
        ctx.put((SecretKey)((Object)DefaultSecretJwk.K.getId()), k);
        return this.createJwkFromValues((JwkContext)ctx);
    }

    private static void assertKeyBitLength(byte[] bytes, MacAlgorithm alg) {
        long requiredBitLen;
        long bitLen = Bytes.bitLength(bytes);
        if (bitLen < (requiredBitLen = (long)alg.getKeyBitLength())) {
            String msg = "Secret JWK " + AbstractJwk.ALG + " value is '" + alg.getId() + "', but the " + DefaultSecretJwk.K + " length is smaller than the " + alg.getId() + " minimum length of " + Bytes.bitsMsg(requiredBitLen) + " required by " + "[JWA RFC 7518, Section 3.2](https://www.rfc-editor.org/rfc/rfc7518.html#section-3.2), " + "2nd paragraph: 'A key of the same size as the hash output or larger MUST be used with this " + "algorithm.'";
            throw new WeakKeyException(msg);
        }
    }

    private static void assertSymmetric(Identifiable alg) {
        if (alg instanceof MacAlgorithm || alg instanceof SecretKeyAlgorithm || alg instanceof AeadAlgorithm) {
            return;
        }
        String msg = "Invalid Secret JWK " + AbstractJwk.ALG + " value '" + alg.getId() + "'. Secret JWKs " + "may only be used with symmetric (secret) key algorithms.";
        throw new MalformedKeyException(msg);
    }

    @Override
    protected SecretJwk createJwkFromValues(JwkContext<SecretKey> ctx) {
        SecretKey key;
        RequiredParameterReader reader = new RequiredParameterReader(ctx);
        byte[] bytes = reader.get(DefaultSecretJwk.K);
        String algId = ctx.getAlgorithm();
        if (!Strings.hasText(algId)) {
            int kBitLen = (int)Bytes.bitLength(bytes);
            SecretKey key2 = ctx.isSigUse() || kBitLen > Jwts.SIG.HS256.getKeyBitLength() ? Keys.hmacShaKeyFor(bytes) : AesAlgorithm.keyFor(bytes);
            ctx.setKey(key2);
            return new DefaultSecretJwk(ctx);
        }
        Identifiable alg = (Identifiable)Jwts.SIG.get().get(algId);
        if (alg == null) {
            alg = (Identifiable)Jwts.KEY.get().get(algId);
        }
        if (alg == null) {
            alg = (Identifiable)Jwts.ENC.get().get(algId);
        }
        if (alg != null) {
            SecretJwkFactory.assertSymmetric(alg);
        }
        if (alg instanceof MacAlgorithm) {
            SecretJwkFactory.assertKeyBitLength(bytes, (MacAlgorithm)alg);
            String jcaName = ((CryptoAlgorithm)alg).getJcaName();
            Assert.hasText(jcaName, "Algorithm jcaName cannot be null or empty.");
            key = new SecretKeySpec(bytes, jcaName);
        } else {
            key = AesAlgorithm.keyFor(bytes);
        }
        ctx.setKey(key);
        return new DefaultSecretJwk(ctx);
    }
}

