/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.IdRegistry;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.AbstractCurve;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.ECCurve;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.EdwardsCurve;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Collections;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.Curve;
import java.security.Key;

public final class StandardCurves
extends IdRegistry<Curve> {
    public StandardCurves() {
        super("Elliptic Curve", Collections.of(ECCurve.P256, ECCurve.P384, ECCurve.P521, EdwardsCurve.X25519, EdwardsCurve.X448, EdwardsCurve.Ed25519, EdwardsCurve.Ed448));
    }

    public static Curve findByKey(Key key) {
        if (key == null) {
            return null;
        }
        AbstractCurve curve = ECCurve.findByKey(key);
        if (curve == null) {
            curve = EdwardsCurve.findByKey(key);
        }
        return curve;
    }
}

