/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.arrow.vector;

import com.salesforce.datacloud.shaded.org.apache.arrow.util.Preconditions;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PeriodDuration
implements TemporalAmount {
    private static final List<TemporalUnit> SUPPORTED_UNITS = Collections.unmodifiableList(Arrays.asList(ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.SECONDS, ChronoUnit.NANOS));
    private final Period period;
    private final Duration duration;

    public PeriodDuration(Period period, Duration duration) {
        this.period = Preconditions.checkNotNull(period);
        this.duration = Preconditions.checkNotNull(duration);
    }

    public Period getPeriod() {
        return this.period;
    }

    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case YEARS: {
                    return this.period.getYears();
                }
                case MONTHS: {
                    return this.period.getMonths();
                }
                case DAYS: {
                    return this.period.getDays();
                }
                case SECONDS: {
                    return this.duration.getSeconds();
                }
                case NANOS: {
                    return this.duration.getNano();
                }
            }
        }
        throw new UnsupportedTemporalTypeException("Unsupported TemporalUnit: " + unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return SUPPORTED_UNITS;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return temporal.plus(this.period).plus(this.duration);
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return temporal.minus(this.period).minus(this.duration);
    }

    public String toISO8601IntervalString() {
        if (this.duration.isZero()) {
            return this.period.toString();
        }
        String durationString = this.duration.toString();
        if (this.period.isZero()) {
            return durationString;
        }
        return this.period + durationString.substring(1);
    }

    public String toString() {
        return this.period.toString() + " " + this.duration.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PeriodDuration)) {
            return false;
        }
        PeriodDuration other = (PeriodDuration)o;
        return this.period.equals(other.period) && this.duration.equals(other.duration);
    }

    public int hashCode() {
        return this.period.hashCode() * 31 + this.duration.hashCode();
    }
}

