/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.arrow.vector;

import com.salesforce.datacloud.shaded.org.apache.arrow.memory.BufferAllocator;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.BitVectorHelper;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.NullCheckingForGet;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.ValueIterableVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.ValueVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.complex.impl.TimeStampSecReaderImpl;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.complex.reader.FieldReader;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableTimeStampSecHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.TimeStampSecHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.types.Types;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.types.pojo.Field;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.util.DateUtility;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.util.TransferPair;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;

public final class TimeStampSecVector
extends TimeStampVector
implements ValueIterableVector<LocalDateTime> {
    public TimeStampSecVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.TIMESTAMPSEC.getType()), allocator);
    }

    public TimeStampSecVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, fieldType, allocator);
    }

    public TimeStampSecVector(Field field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new TimeStampSecReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESTAMPSEC;
    }

    public void get(int index, NullableTimeStampSecHolder holder) {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getLong((long)index * 8L);
    }

    @Override
    public LocalDateTime getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        long secs = this.valueBuffer.getLong((long)index * 8L);
        long millis = TimeUnit.SECONDS.toMillis(secs);
        return DateUtility.getLocalDateTimeFromEpochMilli(millis);
    }

    public void set(int index, NullableTimeStampSecHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, TimeStampSecHolder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, NullableTimeStampSecHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, TimeStampSecHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        TimeStampSecVector to = new TimeStampSecVector(ref, this.field.getFieldType(), allocator);
        return new TimeStampVector.TransferImpl(this, to);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        TimeStampSecVector to = new TimeStampSecVector(field, allocator);
        return new TimeStampVector.TransferImpl(this, to);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TimeStampVector.TransferImpl(this, (TimeStampSecVector)to);
    }
}

