/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.arrow.vector;

import com.salesforce.datacloud.shaded.org.apache.arrow.memory.ArrowBuf;
import com.salesforce.datacloud.shaded.org.apache.arrow.memory.BufferAllocator;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.BaseFixedWidthVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.BaseIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.BitVectorHelper;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.NullCheckingForGet;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.ValueIterableVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.ValueVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.complex.impl.TinyIntReaderImpl;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.complex.reader.FieldReader;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableTinyIntHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.TinyIntHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.types.Types;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.types.pojo.Field;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.util.TransferPair;

public final class TinyIntVector
extends BaseFixedWidthVector
implements BaseIntVector,
ValueIterableVector<Byte> {
    public static final byte TYPE_WIDTH = 1;

    public TinyIntVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.TINYINT.getType()), allocator);
    }

    public TinyIntVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public TinyIntVector(Field field, BufferAllocator allocator) {
        super(field, allocator, 1);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new TinyIntReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TINYINT;
    }

    public byte get(int index) throws IllegalStateException {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getByte(index * 1);
    }

    public void get(int index, NullableTinyIntHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getByte(index * 1);
    }

    @Override
    public Byte getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.getByte(index * 1);
    }

    private void setValue(int index, int value) {
        this.valueBuffer.setByte((long)(index * 1), value);
    }

    private void setValue(int index, byte value) {
        this.valueBuffer.setByte((long)(index * 1), value);
    }

    public void set(int index, int value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, byte value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableTinyIntHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, TinyIntHolder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, int value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, byte value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableTinyIntHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, TinyIntHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void set(int index, int isSet, byte value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, byte value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public static byte get(ArrowBuf buffer, int index) {
        return buffer.getByte(index * 1);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((TinyIntVector)to);
    }

    @Override
    public void setWithPossibleTruncate(int index, long value) {
        this.setSafe(index, (int)value);
    }

    @Override
    public void setUnsafeWithPossibleTruncate(int index, long value) {
        this.set(index, (int)value);
    }

    @Override
    public long getValueAsLong(int index) {
        return this.get(index);
    }

    private class TransferImpl
    implements TransferPair {
        TinyIntVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new TinyIntVector(ref, TinyIntVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Field field, BufferAllocator allocator) {
            this.to = new TinyIntVector(field, allocator);
        }

        public TransferImpl(TinyIntVector to) {
            this.to = to;
        }

        @Override
        public TinyIntVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            TinyIntVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            TinyIntVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, TinyIntVector.this);
        }
    }
}

