/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.arrow.vector.complex.impl;

import com.salesforce.datacloud.shaded.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.complex.writer.TimeStampSecWriter;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableTimeStampSecHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.TimeStampSecHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.types.Types;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.util.DateUtility;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;

public class TimeStampSecHolderReaderImpl
extends AbstractFieldReader {
    private TimeStampSecHolder holder;

    public TimeStampSecHolderReaderImpl(TimeStampSecHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESTAMPSEC;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(TimeStampSecHolder h2) {
        h2.value = this.holder.value;
    }

    @Override
    public void read(NullableTimeStampSecHolder h2) {
        h2.value = this.holder.value;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        long millis = TimeUnit.SECONDS.toMillis(this.holder.value);
        return DateUtility.getLocalDateTimeFromEpochMilli(millis);
    }

    @Override
    public Object readObject() {
        return this.readLocalDateTime();
    }

    @Override
    public void copyAsValue(TimeStampSecWriter writer) {
        writer.write(this.holder);
    }
}

