/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.arrow.vector.dictionary;

import com.salesforce.datacloud.shaded.org.apache.arrow.memory.BufferAllocator;
import com.salesforce.datacloud.shaded.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import com.salesforce.datacloud.shaded.org.apache.arrow.memory.util.hash.SimpleHasher;
import com.salesforce.datacloud.shaded.org.apache.arrow.util.AutoCloseables;
import com.salesforce.datacloud.shaded.org.apache.arrow.util.Preconditions;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.BaseIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.FieldVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.complex.StructVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.dictionary.Dictionary;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.dictionary.DictionaryEncoder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.dictionary.DictionaryHashTable;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.dictionary.DictionaryProvider;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.types.pojo.Field;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.util.TransferPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class StructSubfieldEncoder {
    private final BufferAllocator allocator;
    private final DictionaryProvider.MapDictionaryProvider provider;
    private final Map<Long, DictionaryHashTable> dictionaryIdToHashTable;

    public StructSubfieldEncoder(BufferAllocator allocator, DictionaryProvider.MapDictionaryProvider provider) {
        this(allocator, provider, SimpleHasher.INSTANCE);
    }

    public StructSubfieldEncoder(BufferAllocator allocator, DictionaryProvider.MapDictionaryProvider provider, ArrowBufHasher hasher) {
        this.allocator = allocator;
        this.provider = provider;
        this.dictionaryIdToHashTable = new HashMap<Long, DictionaryHashTable>();
        provider.getDictionaryIds().forEach(id -> this.dictionaryIdToHashTable.put((Long)id, new DictionaryHashTable(provider.lookup((long)id).getVector(), hasher)));
    }

    private static FieldVector getChildVector(StructVector vector, int index) {
        return vector.getChildrenFromFields().get(index);
    }

    private static StructVector cloneVector(StructVector vector, BufferAllocator allocator) {
        FieldType fieldType = vector.getField().getFieldType();
        StructVector cloned = (StructVector)fieldType.createNewSingleVector(vector.getField().getName(), allocator, null);
        ArrowFieldNode fieldNode = new ArrowFieldNode(vector.getValueCount(), vector.getNullCount());
        cloned.loadFieldBuffers(fieldNode, vector.getFieldBuffers());
        return cloned;
    }

    public StructVector encode(StructVector vector, Map<Integer, Long> columnToDictionaryId) {
        int valueCount = vector.getValueCount();
        int childCount = vector.getChildrenFromFields().size();
        ArrayList<Field> childrenFields = new ArrayList<Field>();
        for (int i = 0; i < childCount; ++i) {
            FieldVector childVector = StructSubfieldEncoder.getChildVector(vector, i);
            Long dictionaryId = columnToDictionaryId.get(i);
            if (dictionaryId == null) {
                childrenFields.add(childVector.getField());
                continue;
            }
            Dictionary dictionary = this.provider.lookup(dictionaryId);
            Preconditions.checkNotNull(dictionary, "Dictionary not found with id:" + dictionaryId);
            FieldType indexFieldType = new FieldType(childVector.getField().isNullable(), dictionary.getEncoding().getIndexType(), dictionary.getEncoding());
            childrenFields.add(new Field(childVector.getField().getName(), indexFieldType, null));
        }
        StructVector encoded = StructSubfieldEncoder.cloneVector(vector, this.allocator);
        try {
            encoded.initializeChildrenFromFields(childrenFields);
            encoded.setValueCount(valueCount);
            for (int index = 0; index < childCount; ++index) {
                FieldVector childVector = StructSubfieldEncoder.getChildVector(vector, index);
                FieldVector encodedChildVector = StructSubfieldEncoder.getChildVector(encoded, index);
                Long dictionaryId = columnToDictionaryId.get(index);
                if (dictionaryId != null) {
                    BaseIntVector indices = (BaseIntVector)encodedChildVector;
                    DictionaryEncoder.buildIndexVector(childVector, indices, this.dictionaryIdToHashTable.get(dictionaryId), 0, valueCount);
                    continue;
                }
                childVector.makeTransferPair(encodedChildVector).splitAndTransfer(0, valueCount);
            }
            return encoded;
        }
        catch (Exception e) {
            AutoCloseables.close((Throwable)e, (Iterable<? extends AutoCloseable>)encoded);
            throw e;
        }
    }

    public StructVector decode(StructVector vector) {
        return StructSubfieldEncoder.decode(vector, this.provider, this.allocator);
    }

    public static StructVector decode(StructVector vector, DictionaryProvider.MapDictionaryProvider provider, BufferAllocator allocator) {
        int valueCount = vector.getValueCount();
        int childCount = vector.getChildrenFromFields().size();
        StructVector decoded = StructSubfieldEncoder.cloneVector(vector, allocator);
        try {
            FieldVector childVector;
            ArrayList<Field> childFields = new ArrayList<Field>();
            for (int i = 0; i < childCount; ++i) {
                childVector = StructSubfieldEncoder.getChildVector(vector, i);
                Dictionary dictionary = StructSubfieldEncoder.getChildVectorDictionary(childVector, provider);
                if (dictionary == null) {
                    childFields.add(childVector.getField());
                    continue;
                }
                childFields.add(dictionary.getVector().getField());
            }
            decoded.initializeChildrenFromFields(childFields);
            decoded.setValueCount(valueCount);
            for (int index = 0; index < childCount; ++index) {
                childVector = StructSubfieldEncoder.getChildVector(vector, index);
                FieldVector decodedChildVector = StructSubfieldEncoder.getChildVector(decoded, index);
                Dictionary dictionary = StructSubfieldEncoder.getChildVectorDictionary(childVector, provider);
                if (dictionary == null) {
                    childVector.makeTransferPair(decodedChildVector).splitAndTransfer(0, valueCount);
                    continue;
                }
                TransferPair transfer = dictionary.getVector().makeTransferPair(decodedChildVector);
                BaseIntVector indices = (BaseIntVector)childVector;
                DictionaryEncoder.retrieveIndexVector(indices, transfer, valueCount, 0, valueCount);
            }
            return decoded;
        }
        catch (Exception e) {
            AutoCloseables.close((Throwable)e, (Iterable<? extends AutoCloseable>)decoded);
            throw e;
        }
    }

    private static Dictionary getChildVectorDictionary(FieldVector childVector, DictionaryProvider.MapDictionaryProvider provider) {
        DictionaryEncoding dictionaryEncoding = childVector.getField().getDictionary();
        if (dictionaryEncoding != null) {
            Dictionary dictionary = provider.lookup(dictionaryEncoding.getId());
            Preconditions.checkNotNull(dictionary, "Dictionary not found with id:" + dictionary);
            return dictionary;
        }
        return null;
    }
}

