/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.calcite.avatica.remote;

import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.AvaticaUtils;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.remote.AvaticaHttpClient;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class AvaticaHttpClientImpl
implements AvaticaHttpClient {
    protected final URL url;

    public AvaticaHttpClientImpl(URL url) {
        this.url = url;
    }

    @Override
    public byte[] send(byte[] request) {
        try {
            InputStream inputStream2;
            HttpURLConnection connection;
            int responseCode;
            do {
                connection = this.openConnection();
                connection.setRequestMethod("POST");
                connection.setDoInput(true);
                connection.setDoOutput(true);
                try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                    wr.write(request);
                    wr.flush();
                    wr.close();
                }
            } while ((responseCode = connection.getResponseCode()) == 503);
            if (responseCode != 200) {
                inputStream2 = connection.getErrorStream();
                if (inputStream2 == null) {
                    throw new RuntimeException("Failed to read data from the server: HTTP/" + responseCode);
                }
            } else {
                inputStream2 = connection.getInputStream();
            }
            return AvaticaUtils.readFullyToBytes(inputStream2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    HttpURLConnection openConnection() throws IOException {
        return (HttpURLConnection)this.url.openConnection();
    }
}

