/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.calcite.avatica.remote;

import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.ConnectionConfig;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.remote.HostnameVerificationConfigurable;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.ssl.HttpsSupport;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.ssl.SSLContextBuilder;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.ssl.SSLContexts;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsHttpClientPoolCache {
    private static final String MAX_POOLED_CONNECTION_PER_ROUTE_KEY = "avatica.pooled.connections.per.route";
    private static final String MAX_POOLED_CONNECTION_PER_ROUTE_DEFAULT = "25";
    private static final String MAX_POOLED_CONNECTIONS_KEY = "avatica.pooled.connections.max";
    private static final String MAX_POOLED_CONNECTIONS_DEFAULT = "100";
    private static final Logger LOG = LoggerFactory.getLogger(CommonsHttpClientPoolCache.class);
    private static final ConcurrentHashMap<String, PoolingHttpClientConnectionManager> CACHED_POOLS = new ConcurrentHashMap();

    private CommonsHttpClientPoolCache() {
    }

    public static PoolingHttpClientConnectionManager getPool(ConnectionConfig config) {
        String sslDisc = CommonsHttpClientPoolCache.extractSSLParameters(config);
        return CACHED_POOLS.computeIfAbsent(sslDisc, k -> CommonsHttpClientPoolCache.setupPool(config));
    }

    private static PoolingHttpClientConnectionManager setupPool(ConnectionConfig config) {
        String maxCnxns = System.getProperty(MAX_POOLED_CONNECTIONS_KEY, MAX_POOLED_CONNECTIONS_DEFAULT);
        String maxCnxnsPerRoute = System.getProperty(MAX_POOLED_CONNECTION_PER_ROUTE_KEY, MAX_POOLED_CONNECTION_PER_ROUTE_DEFAULT);
        PoolingHttpClientConnectionManager pool = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy(CommonsHttpClientPoolCache.createTlsSocketStrategy(config)).setMaxConnTotal(Integer.parseInt(maxCnxns)).setMaxConnPerRoute(Integer.parseInt(maxCnxnsPerRoute)).build();
        LOG.debug("Created new pool {}", (Object)pool);
        return pool;
    }

    private static TlsSocketStrategy createTlsSocketStrategy(ConnectionConfig config) {
        try {
            return new DefaultClientTlsStrategy(CommonsHttpClientPoolCache.getSSLContext(config), CommonsHttpClientPoolCache.getHostnameVerifier(config.hostnameVerification()));
        }
        catch (Exception e) {
            LOG.error("HTTPS TlsSocketStrategy configuration failed");
            throw new RuntimeException(e);
        }
    }

    private static SSLContext getSSLContext(ConnectionConfig config) throws Exception {
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        if (null != config.keystoreType()) {
            sslContextBuilder.setKeyStoreType(config.keystoreType());
        }
        if (null != config.truststore() && null != config.truststorePassword()) {
            CommonsHttpClientPoolCache.loadTrustStore(sslContextBuilder, config);
        }
        if (null != config.keystore() && null != config.keystorePassword() && null != config.keyPassword()) {
            CommonsHttpClientPoolCache.loadKeyStore(sslContextBuilder, config);
        }
        return sslContextBuilder.build();
    }

    private static void loadKeyStore(SSLContextBuilder sslContextBuilder, ConnectionConfig config) throws Exception {
        sslContextBuilder.loadKeyMaterial(config.keystore(), config.keystorePassword().toCharArray(), config.keyPassword().toCharArray());
    }

    private static void loadTrustStore(SSLContextBuilder sslContextBuilder, ConnectionConfig config) throws Exception {
        sslContextBuilder.loadTrustMaterial(config.truststore(), config.truststorePassword().toCharArray());
        LOG.info("Trustore loaded from: {}", (Object)config.truststore());
    }

    private static HostnameVerifier getHostnameVerifier(HostnameVerificationConfigurable.HostnameVerification verification) {
        if (verification == null) {
            verification = HostnameVerificationConfigurable.HostnameVerification.STRICT;
        }
        switch (verification) {
            case STRICT: {
                return HttpsSupport.getDefaultHostnameVerifier();
            }
            case NONE: {
                return NoopHostnameVerifier.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unhandled HostnameVerification: " + verification.name());
    }

    private static String extractSSLParameters(ConnectionConfig config) {
        long keyMtime = 0L;
        if (config.keystore() != null && config.keystore().canRead()) {
            try {
                keyMtime = Files.readAttributes(config.keystore().toPath(), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        long trustMtime = 0L;
        if (config.truststore() != null && config.truststore().canRead()) {
            try {
                trustMtime = Files.readAttributes(config.truststore().toPath(), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(config.hostnameVerification().toString()).append(":").append(config.keystoreType()).append(":").append(config.truststore()).append(":").append(config.truststorePassword()).append(":").append(config.keystore()).append(":").append(config.keystorePassword()).append(":").append(config.keyPassword()).append(":").append(keyMtime).append(":").append(trustMtime);
        return sb.toString();
    }
}

