/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.classic;

import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.HttpRoute;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.classic.BackoffManager;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.pool.ConnPoolControl;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.Args;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.TimeValue;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBackoff
implements BackoffManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBackoff.class);
    private final ConnPoolControl<HttpRoute> connPerRoute;
    private final Map<HttpRoute, Instant> lastRouteProbes;
    private final Map<HttpRoute, Instant> lastRouteBackoffs;
    private final AtomicReference<TimeValue> coolDown = new AtomicReference<TimeValue>(TimeValue.ofSeconds(5L));
    private final AtomicReference<Double> backoffFactor = new AtomicReference<Double>(0.5);
    private final AtomicInteger cap = new AtomicInteger(2);
    private final AtomicInteger timeInterval = new AtomicInteger(0);

    public AbstractBackoff(ConnPoolControl<HttpRoute> connPerRoute) {
        this.connPerRoute = Args.notNull(connPerRoute, "Connection pool control");
        this.lastRouteProbes = new ConcurrentHashMap<HttpRoute, Instant>();
        this.lastRouteBackoffs = new ConcurrentHashMap<HttpRoute, Instant>();
    }

    @Override
    public void backOff(HttpRoute route) {
        int curr = this.connPerRoute.getMaxPerRoute(route);
        Instant now = Instant.now();
        this.lastRouteBackoffs.compute(route, (r, lastUpdate) -> {
            if (lastUpdate == null || now.isAfter(lastUpdate.plus(this.coolDown.get().toMilliseconds(), ChronoUnit.MILLIS))) {
                int backedOffPoolSize = this.getBackedOffPoolSize(curr);
                this.connPerRoute.setMaxPerRoute(route, backedOffPoolSize);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Backoff applied for route: {}, new max connections: {}", (Object)route, (Object)this.connPerRoute.getMaxPerRoute(route));
                }
                return now;
            }
            return lastUpdate;
        });
    }

    protected abstract int getBackedOffPoolSize(int var1);

    @Override
    public void probe(HttpRoute route) {
        int curr = this.connPerRoute.getMaxPerRoute(route);
        int max = curr >= this.cap.get() ? this.cap.get() : curr + 1;
        Instant now = Instant.now();
        this.lastRouteProbes.compute(route, (r, lastProbe) -> {
            Instant lastBackoff;
            if ((lastProbe == null || now.isAfter(lastProbe.plus(this.coolDown.get().toMilliseconds(), ChronoUnit.MILLIS))) && ((lastBackoff = this.lastRouteBackoffs.get(r)) == null || now.isAfter(lastBackoff.plus(this.coolDown.get().toMilliseconds(), ChronoUnit.MILLIS)))) {
                this.connPerRoute.setMaxPerRoute(route, max);
                if (LOG.isDebugEnabled()) {
                    LOG.info("Probe applied for route: {}, new max connections: {}", (Object)route, (Object)this.connPerRoute.getMaxPerRoute(route));
                }
                this.timeInterval.set(0);
                return now;
            }
            return lastProbe;
        });
    }

    public long getLastUpdate(Map<HttpRoute, Long> updates, HttpRoute route) {
        return updates.getOrDefault(route, 0L);
    }

    public void setPerHostConnectionCap(int cap) {
        Args.positive(cap, "Per host connection cap");
        this.cap.set(cap);
    }

    abstract void setBackoffFactor(double var1);

    public void setCoolDown(TimeValue coolDown) {
        Args.notNull(coolDown, "Cool down time value cannot be null");
        Args.positive(coolDown.getDuration(), "coolDown");
        this.coolDown.set(coolDown);
    }

    protected ConnPoolControl<HttpRoute> getConnPerRoute() {
        return this.connPerRoute;
    }

    protected Map<HttpRoute, Instant> getLastRouteProbes() {
        return this.lastRouteProbes;
    }

    protected Map<HttpRoute, Instant> getLastRouteBackoffs() {
        return this.lastRouteBackoffs;
    }

    protected AtomicReference<TimeValue> getCoolDown() {
        return this.coolDown;
    }

    protected AtomicReference<Double> getBackoffFactor() {
        return this.backoffFactor;
    }

    protected AtomicInteger getCap() {
        return this.cap;
    }

    protected AtomicInteger getTimeInterval() {
        return this.timeInterval;
    }
}

