/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.hc.core5.http.message;

import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.FormattedHeader;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.ParseException;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.Args;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.CharArrayBuffer;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.Tokenizer;
import java.io.Serializable;

public class BufferedHeader
implements FormattedHeader,
Serializable {
    private static final long serialVersionUID = -2768352615787625448L;
    private final String name;
    private final CharArrayBuffer buffer;
    private final int valuePos;
    private String value;

    public static BufferedHeader create(CharArrayBuffer buffer) {
        try {
            return new BufferedHeader(buffer);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public BufferedHeader(CharArrayBuffer buffer) throws ParseException {
        this(buffer, true);
    }

    BufferedHeader(CharArrayBuffer buffer, boolean strict) throws ParseException {
        Args.notNull(buffer, "Char array buffer");
        int colon = buffer.indexOf(58);
        if (colon <= 0) {
            throw new ParseException("Invalid header", buffer, 0, buffer.length());
        }
        if (strict && Tokenizer.isWhitespace(buffer.charAt(colon - 1))) {
            throw new ParseException("Invalid header", buffer, 0, buffer.length(), colon - 1);
        }
        String s2 = buffer.substringTrimmed(0, colon);
        if (s2.isEmpty()) {
            throw new ParseException("Invalid header", buffer, 0, buffer.length(), colon);
        }
        this.buffer = buffer;
        this.name = s2;
        this.valuePos = colon + 1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            int beginIdx;
            int endIdx = this.buffer.length();
            for (beginIdx = this.valuePos; beginIdx < this.buffer.length() && Tokenizer.isWhitespace(this.buffer.charAt(beginIdx)); ++beginIdx) {
            }
            while (endIdx > beginIdx && Tokenizer.isWhitespace(this.buffer.charAt(endIdx - 1))) {
                --endIdx;
            }
            StringBuilder buf = new StringBuilder(endIdx - beginIdx);
            for (int i = beginIdx; i < endIdx; ++i) {
                char ch = this.buffer.charAt(i);
                if (ch == '\r' || ch == '\n' || ch == '\u0000') {
                    buf.append(' ');
                    continue;
                }
                buf.append(ch);
            }
            this.value = buf.toString();
        }
        return this.value;
    }

    @Override
    public boolean isSensitive() {
        return false;
    }

    @Override
    public int getValuePos() {
        return this.valuePos;
    }

    @Override
    public CharArrayBuffer getBuffer() {
        return this.buffer;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

