/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.hc.core5.http.nio.support;

import com.salesforce.datacloud.shaded.org.apache.hc.core5.concurrent.CallbackContribution;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.concurrent.FutureCallback;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.function.Supplier;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.EntityDetails;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.Header;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.HttpException;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.HttpRequest;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.Message;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.nio.AsyncRequestConsumer;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.nio.CapacityChannel;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class BasicRequestConsumer<T>
implements AsyncRequestConsumer<Message<HttpRequest, T>> {
    private final Supplier<AsyncEntityConsumer<T>> dataConsumerSupplier;
    private final AtomicReference<AsyncEntityConsumer<T>> dataConsumerRef;

    public BasicRequestConsumer(Supplier<AsyncEntityConsumer<T>> dataConsumerSupplier) {
        this.dataConsumerSupplier = Args.notNull(dataConsumerSupplier, "Data consumer supplier");
        this.dataConsumerRef = new AtomicReference();
    }

    public BasicRequestConsumer(AsyncEntityConsumer<T> dataConsumer) {
        this(() -> dataConsumer);
    }

    @Override
    public void consumeRequest(final HttpRequest request, EntityDetails entityDetails, HttpContext httpContext, final FutureCallback<Message<HttpRequest, T>> resultCallback) throws HttpException, IOException {
        Args.notNull(request, "Request");
        if (entityDetails != null) {
            AsyncEntityConsumer<T> dataConsumer = this.dataConsumerSupplier.get();
            if (dataConsumer == null) {
                throw new HttpException("Supplied data consumer is null");
            }
            this.dataConsumerRef.set(dataConsumer);
            dataConsumer.streamStart(entityDetails, new CallbackContribution<T>(resultCallback){

                @Override
                public void completed(T body) {
                    if (resultCallback != null) {
                        resultCallback.completed(new Message(request, body));
                    }
                }
            });
        } else if (resultCallback != null) {
            resultCallback.completed(new Message(request));
        }
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        AsyncEntityConsumer<T> dataConsumer = this.dataConsumerRef.get();
        dataConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public void consume(ByteBuffer src) throws IOException {
        AsyncEntityConsumer<T> dataConsumer = this.dataConsumerRef.get();
        dataConsumer.consume(src);
    }

    @Override
    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        AsyncEntityConsumer<T> dataConsumer = this.dataConsumerRef.get();
        dataConsumer.streamEnd(trailers);
    }

    @Override
    public void failed(Exception cause) {
        this.releaseResources();
    }

    @Override
    public void releaseResources() {
        AsyncEntityConsumer dataConsumer = this.dataConsumerRef.getAndSet(null);
        if (dataConsumer != null) {
            dataConsumer.releaseResources();
        }
    }
}

