/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.hc.core5.http.protocol;

import com.salesforce.datacloud.shaded.org.apache.hc.core5.annotation.Contract;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;

@Contract(threading=ThreadingBehavior.SAFE)
public class HttpDateGenerator {
    private static final int GRANULARITY_MILLIS = 1000;
    @Deprecated
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String INTERNET_MESSAGE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    @Deprecated
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final ZoneId GMT_ID = ZoneId.of("GMT");
    public static final HttpDateGenerator INSTANCE = new HttpDateGenerator("EEE, dd MMM yyyy HH:mm:ss zzz", GMT_ID);
    private final DateTimeFormatter dateTimeFormatter;
    private long dateAsMillis;
    private String dateAsText;
    private ZoneId zoneId;
    private final ReentrantLock lock;

    private HttpDateGenerator(String pattern, ZoneId zoneId) {
        this.dateTimeFormatter = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(pattern).toFormatter();
        this.zoneId = zoneId;
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentDate() {
        this.lock.lock();
        try {
            long now = System.currentTimeMillis();
            if (now - this.dateAsMillis > 1000L) {
                this.dateAsText = this.dateTimeFormatter.format(Instant.now().atZone(this.zoneId));
                this.dateAsMillis = now;
            }
            String string = this.dateAsText;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }
}

