/*
 * Decompiled with CFR 0.152.
 */
package com.force.db.i18n.util;

public final class DeferredStringBuilder
implements Appendable,
CharSequence {
    private StringBuilder buf;
    private int pos;
    private final CharSequence source;

    public DeferredStringBuilder(CharSequence source) {
        if (source == null) {
            this.buf = new StringBuilder(16);
        }
        this.source = source;
    }

    @Override
    public DeferredStringBuilder append(char c) {
        if (this.buf == null) {
            if (this.pos < this.source.length() && c == this.source.charAt(this.pos)) {
                ++this.pos;
            } else {
                this.buf = new StringBuilder(this.source.length() + 16);
                this.buf.append(this.source.subSequence(0, this.pos));
                this.buf.append(c);
            }
        } else {
            this.buf.append(c);
        }
        return this;
    }

    public void appendQuicklyForEscapingWithoutSkips(char c) {
        if (this.buf == null) {
            assert (c == this.source.charAt(this.pos) && this.pos < this.source.length()) : "You've violated the guarantee";
            ++this.pos;
        } else {
            this.buf.append(c);
        }
    }

    public void appendQuicklyForEscapingWithoutSkips(int c) {
        if (this.buf == null) {
            ++this.pos;
        } else {
            this.buf.append((char)c);
        }
    }

    @Override
    public DeferredStringBuilder append(CharSequence csq) {
        if (csq == null) {
            return this;
        }
        return this.append(csq, 0, csq.length());
    }

    public void appendAsDifferent(CharSequence csq) {
        if (csq == null) {
            return;
        }
        if (this.buf == null) {
            this.buf = new StringBuilder(this.source.length() + 16);
            this.buf.append(this.source.subSequence(0, this.pos));
            this.buf.append(csq);
        } else {
            this.buf.append(csq);
        }
    }

    public void appendAsDifferent(char c) {
        if (this.buf == null) {
            this.buf = new StringBuilder(this.source.length() + 16);
            this.buf.append(this.source.subSequence(0, this.pos));
            this.buf.append(c);
        } else {
            this.buf.append(c);
        }
    }

    @Override
    public DeferredStringBuilder append(CharSequence csq, int start, int end) {
        if (csq != null) {
            if (this.buf == null) {
                int chars = end - start;
                if (chars < 10 || this.pos + chars > this.source.length()) {
                    for (int i = start; i < end; ++i) {
                        this.append(csq.charAt(i));
                    }
                } else {
                    CharSequence subSeq = csq.subSequence(start, end);
                    if (this.source.subSequence(this.pos, this.pos + chars).equals(subSeq)) {
                        this.pos += chars;
                    } else {
                        this.buf = new StringBuilder(this.source.length() + 16);
                        this.buf.append(this.source.subSequence(0, this.pos));
                        this.buf.append(subSeq);
                    }
                }
            } else {
                this.buf.append(csq, start, end);
            }
        }
        return this;
    }

    @Override
    public char charAt(int index) {
        if (this.buf != null) {
            return this.buf.charAt(index);
        }
        if (index < this.pos) {
            return this.source.charAt(index);
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (this.buf != null) {
            return this.buf.subSequence(start, end);
        }
        if (end <= this.pos) {
            return this.source.subSequence(start, end);
        }
        throw new StringIndexOutOfBoundsException(end);
    }

    @Override
    public String toString() {
        return this.buf != null ? this.buf.toString() : (this.pos == this.source.length() ? this.source.toString() : this.source.subSequence(0, this.pos).toString());
    }

    @Override
    public int length() {
        return this.buf != null ? this.buf.length() : this.pos;
    }
}

