/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib;

import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.salesforce.grpc.contrib.MoreFutures;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public final class FutureChain<T> {
    private final ListenableFuture<T> future;
    private final Executor executor;

    public static <T> FutureChain<T> startWith(ListenableFuture<T> startFuture, Executor executor) {
        return new FutureChain<T>(startFuture, executor);
    }

    private FutureChain(ListenableFuture<T> future, Executor executor) {
        this.future = future;
        this.executor = executor;
    }

    public FutureChain<T> switchExecutor(Executor newExecutor) {
        return new FutureChain<T>(this.future, newExecutor);
    }

    public <U> FutureChain<U> transform(Function<? super T, ? extends U> function) {
        return new FutureChain<T>(Futures.transform(this.future, function, (Executor)this.executor), this.executor);
    }

    public <U> FutureChain<U> transformAsync(AsyncFunction<? super T, ? extends U> function) {
        return new FutureChain<T>(Futures.transformAsync(this.future, function, (Executor)this.executor), this.executor);
    }

    public <E extends Throwable> FutureChain<T> catching(Class<E> exceptionType, Function<? super E, ? extends T> fallback) {
        return new FutureChain<T>(Futures.catching(this.future, exceptionType, fallback, (Executor)this.executor), this.executor);
    }

    public <E extends Throwable> FutureChain<T> catchingAsync(Class<E> exceptionType, AsyncFunction<? super E, ? extends T> fallback) {
        return new FutureChain<T>(Futures.catchingAsync(this.future, exceptionType, fallback, (Executor)this.executor), this.executor);
    }

    public FutureChain<T> addCallback(FutureCallback<? super T> callback) {
        Futures.addCallback(this.future, callback, (Executor)this.executor);
        return this;
    }

    public FutureChain<T> addCallback(@Nonnull Consumer<T> success, @Nonnull Consumer<Throwable> failure) {
        MoreFutures.addCallback(this.future, success, failure, this.executor);
        return this;
    }

    public FutureChain<T> onSuccess(@Nonnull Consumer<T> success) {
        MoreFutures.onSuccess(this.future, success, this.executor);
        return this;
    }

    public FutureChain<T> onFailure(@Nonnull Consumer<Throwable> failure) {
        MoreFutures.onFailure(this.future, failure, this.executor);
        return this;
    }

    public ListenableFuture<T> compile() {
        return this.future;
    }
}

