/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.testing.contrib;

import io.grpc.Context;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class GrpcContextRule
implements TestRule {
    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Context prev = Context.ROOT.attach();
                try {
                    base.evaluate();
                    if (Context.current() != Context.ROOT) {
                        Assert.fail((String)"Test is leaking context state between tests! Ensure proper attach()/detach() pairing.");
                    }
                }
                finally {
                    Context.ROOT.detach(prev);
                }
            }
        };
    }
}

