/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.testing.contrib;

import com.google.common.base.Preconditions;
import com.salesforce.grpc.contrib.Servers;
import io.grpc.HandlerRegistry;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.util.MutableHandlerRegistry;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.junit.rules.ExternalResource;

public class NettyGrpcServerRule
extends ExternalResource {
    private ManagedChannel channel;
    private Server server;
    private MutableHandlerRegistry serviceRegistry;
    private boolean useDirectExecutor;
    private int port = 0;
    private Consumer<NettyServerBuilder> configureServerBuilder = sb -> {};
    private Consumer<NettyChannelBuilder> configureChannelBuilder = cb -> {};

    public final NettyGrpcServerRule configureServerBuilder(Consumer<NettyServerBuilder> configureServerBuilder) {
        Preconditions.checkState((this.port == 0 ? 1 : 0) != 0, (Object)"configureServerBuilder() can only be called at the rule instantiation");
        this.configureServerBuilder = (Consumer)Preconditions.checkNotNull(configureServerBuilder, (Object)"configureServerBuilder");
        return this;
    }

    public final NettyGrpcServerRule configureChannelBuilder(Consumer<NettyChannelBuilder> configureChannelBuilder) {
        Preconditions.checkState((this.port == 0 ? 1 : 0) != 0, (Object)"configureChannelBuilder() can only be called at the rule instantiation");
        this.configureChannelBuilder = (Consumer)Preconditions.checkNotNull(configureChannelBuilder, (Object)"configureChannelBuilder");
        return this;
    }

    public final ManagedChannel getChannel() {
        return this.channel;
    }

    public final Server getServer() {
        return this.server;
    }

    public final int getPort() {
        return this.port;
    }

    public final MutableHandlerRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected void before() throws Throwable {
        this.serviceRegistry = new MutableHandlerRegistry();
        NettyServerBuilder serverBuilder = (NettyServerBuilder)NettyServerBuilder.forPort((int)0).fallbackHandlerRegistry((HandlerRegistry)this.serviceRegistry);
        if (this.useDirectExecutor) {
            serverBuilder.directExecutor();
        }
        this.configureServerBuilder.accept(serverBuilder);
        this.server = serverBuilder.build().start();
        this.port = this.server.getPort();
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)"localhost", (int)this.port).usePlaintext(true);
        this.configureChannelBuilder.accept(channelBuilder);
        this.channel = channelBuilder.build();
    }

    protected void after() {
        this.serviceRegistry = null;
        this.channel.shutdown();
        this.channel = null;
        this.port = 0;
        try {
            Servers.shutdownGracefully((Server)this.server, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        finally {
            this.server = null;
        }
    }
}

