/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.jprotoc;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.protobuf.compiler.PluginProtos;
import com.salesforce.jprotoc.GeneratorException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class Generator {
    private static MustacheFactory mustacheFactory = new DefaultMustacheFactory();

    public abstract Stream<PluginProtos.CodeGeneratorResponse.File> generate(PluginProtos.CodeGeneratorRequest var1) throws GeneratorException;

    protected String applyTemplate(@Nonnull String resourcePath, @Nonnull Object generatorContext) {
        Preconditions.checkNotNull((Object)resourcePath, (Object)"resourcePath");
        Preconditions.checkNotNull((Object)generatorContext, (Object)"generatorContext");
        InputStream resource = MustacheFactory.class.getClassLoader().getResourceAsStream(resourcePath);
        if (resource == null) {
            throw new RuntimeException("Could not find resource " + resourcePath);
        }
        InputStreamReader resourceReader = new InputStreamReader(resource, Charsets.UTF_8);
        Mustache template = mustacheFactory.compile((Reader)resourceReader, resourcePath);
        return template.execute((Writer)new StringWriter(), generatorContext).toString();
    }
}

