/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.jprotoc;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.DescriptorProtos;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ProtoTypeMap {
    private final ImmutableMap<String, String> types;

    private ProtoTypeMap(@Nonnull ImmutableMap<String, String> types) {
        Preconditions.checkNotNull(types, (Object)"types");
        this.types = types;
    }

    public static ProtoTypeMap of(@Nonnull Collection<DescriptorProtos.FileDescriptorProto> fileDescriptorProtos) {
        Preconditions.checkNotNull(fileDescriptorProtos, (Object)"fileDescriptorProtos");
        Preconditions.checkArgument((!fileDescriptorProtos.isEmpty() ? 1 : 0) != 0, (Object)"fileDescriptorProtos.isEmpty()");
        ImmutableMap.Builder types = ImmutableMap.builder();
        for (DescriptorProtos.FileDescriptorProto fileDescriptor : fileDescriptorProtos) {
            DescriptorProtos.FileOptions fileOptions = fileDescriptor.getOptions();
            String protoPackage = fileDescriptor.hasPackage() ? "." + fileDescriptor.getPackage() : "";
            String javaPackage = Strings.emptyToNull((String)(fileOptions.hasJavaPackage() ? fileOptions.getJavaPackage() : fileDescriptor.getPackage()));
            String enclosingClassName = fileOptions.getJavaMultipleFiles() ? null : ProtoTypeMap.getJavaOuterClassname(fileDescriptor, fileOptions);
            fileDescriptor.getEnumTypeList().forEach(e -> types.put((Object)(protoPackage + "." + e.getName()), (Object)ProtoTypeMap.toJavaTypeName(e.getName(), enclosingClassName, javaPackage)));
            fileDescriptor.getMessageTypeList().forEach(m -> types.put((Object)(protoPackage + "." + m.getName()), (Object)ProtoTypeMap.toJavaTypeName(m.getName(), enclosingClassName, javaPackage)));
        }
        return new ProtoTypeMap((ImmutableMap<String, String>)types.build());
    }

    public String toJavaTypeName(@Nonnull String protoTypeName) {
        Preconditions.checkNotNull((Object)protoTypeName, (Object)"protoTypeName");
        return (String)this.types.get((Object)protoTypeName);
    }

    public static String toJavaTypeName(@Nonnull String className, @Nullable String enclosingClassName, @Nullable String javaPackage) {
        Preconditions.checkNotNull((Object)className, (Object)"className");
        Joiner dotJoiner = Joiner.on((char)'.').skipNulls();
        return dotJoiner.join((Object)javaPackage, (Object)enclosingClassName, new Object[]{className});
    }

    private static String getJavaOuterClassname(DescriptorProtos.FileDescriptorProto fileDescriptor, DescriptorProtos.FileOptions fileOptions) {
        if (fileOptions.hasJavaOuterClassname()) {
            return fileOptions.getJavaOuterClassname();
        }
        String filename = fileDescriptor.getName().substring(0, fileDescriptor.getName().length() - ".proto".length());
        if (filename.contains("/")) {
            filename = filename.substring(filename.lastIndexOf(47) + 1);
        }
        filename = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, filename);
        filename = ProtoTypeMap.appendOuterClassSuffix(filename, fileDescriptor);
        return filename;
    }

    private static String appendOuterClassSuffix(String enclosingClassName, DescriptorProtos.FileDescriptorProto fd) {
        if (fd.getEnumTypeList().stream().anyMatch(enumProto -> enumProto.getName().equals(enclosingClassName)) || fd.getMessageTypeList().stream().anyMatch(messageProto -> messageProto.getName().equals(enclosingClassName)) || fd.getServiceList().stream().anyMatch(serviceProto -> serviceProto.getName().equals(enclosingClassName))) {
            return enclosingClassName + "OuterClass";
        }
        return enclosingClassName;
    }
}

