/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.jprotoc;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.compiler.PluginProtos;
import com.salesforce.jprotoc.Generator;
import com.salesforce.jprotoc.GeneratorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ProtocPlugin {
    private ProtocPlugin() {
    }

    public static void generate(@Nonnull Generator generator) {
        Preconditions.checkNotNull((Object)generator, (Object)"generator");
        ProtocPlugin.generate(Collections.singletonList(generator));
    }

    public static void generate(@Nonnull List<Generator> generators) {
        ProtocPlugin.generate(generators, Collections.emptyList());
    }

    public static void generate(@Nonnull List<Generator> generators, List<GeneratedMessage.GeneratedExtension> extensions) {
        Preconditions.checkNotNull(generators, (Object)"generators");
        Preconditions.checkArgument((!generators.isEmpty() ? 1 : 0) != 0, (Object)"generators.isEmpty()");
        Preconditions.checkNotNull(extensions, (Object)"extensions");
        ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();
        for (GeneratedMessage.GeneratedExtension extension : extensions) {
            extensionRegistry.add(extension);
        }
        try {
            byte[] generatorRequestBytes = ByteStreams.toByteArray((InputStream)System.in);
            PluginProtos.CodeGeneratorRequest request = PluginProtos.CodeGeneratorRequest.parseFrom((byte[])generatorRequestBytes, (ExtensionRegistryLite)extensionRegistry);
            List outputFiles = generators.stream().flatMap(gen -> gen.generate(request)).collect(Collectors.toList());
            PluginProtos.CodeGeneratorResponse response = PluginProtos.CodeGeneratorResponse.newBuilder().addAllFile(outputFiles).build();
            response.writeTo((OutputStream)System.out);
        }
        catch (GeneratorException ex) {
            try {
                PluginProtos.CodeGeneratorResponse.newBuilder().setError(ex.getMessage()).build().writeTo((OutputStream)System.out);
            }
            catch (IOException ex2) {
                ProtocPlugin.abort(ex2);
            }
        }
        catch (Throwable ex) {
            ProtocPlugin.abort(ex);
        }
    }

    private static void abort(Throwable ex) {
        ex.printStackTrace(System.err);
        System.exit(1);
    }
}

