/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.jprotoc.jdk8;

import com.google.common.base.Strings;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.compiler.PluginProtos;
import com.salesforce.jprotoc.Generator;
import com.salesforce.jprotoc.GeneratorException;
import com.salesforce.jprotoc.ProtoTypeMap;
import com.salesforce.jprotoc.ProtocPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class Jdk8Generator
extends Generator {
    private static final String CLASS_SUFFIX = "Grpc8";

    public static void main(String[] args) {
        ProtocPlugin.generate(new Jdk8Generator());
    }

    @Override
    public Stream<PluginProtos.CodeGeneratorResponse.File> generate(PluginProtos.CodeGeneratorRequest request) throws GeneratorException {
        ProtoTypeMap protoTypeMap = ProtoTypeMap.of(request.getProtoFileList());
        return request.getProtoFileList().stream().filter(protoFile -> request.getFileToGenerateList().contains((Object)protoFile.getName())).flatMap(f -> this.extractContext(protoTypeMap, (DescriptorProtos.FileDescriptorProto)f)).map(this::buildFile);
    }

    private Stream<Context> extractContext(ProtoTypeMap protoTypeMap, DescriptorProtos.FileDescriptorProto proto) {
        return proto.getServiceList().stream().map(s -> this.extractServiceContext(protoTypeMap, (DescriptorProtos.ServiceDescriptorProto)s)).map(ctx -> {
            ctx.packageName = this.extractPackageName(proto);
            return ctx;
        }).map(ctx -> {
            ctx.protoName = proto.getName();
            return ctx;
        });
    }

    private String extractPackageName(DescriptorProtos.FileDescriptorProto proto) {
        String javaPackage;
        DescriptorProtos.FileOptions options = proto.getOptions();
        if (options != null && !Strings.isNullOrEmpty((String)(javaPackage = options.getJavaPackage()))) {
            return javaPackage;
        }
        return Strings.nullToEmpty((String)proto.getPackage());
    }

    private Context extractServiceContext(ProtoTypeMap protoTypeMap, DescriptorProtos.ServiceDescriptorProto serviceProto) {
        Context ctx = new Context();
        ctx.fileName = serviceProto.getName() + CLASS_SUFFIX + ".java";
        ctx.className = serviceProto.getName() + CLASS_SUFFIX;
        ctx.serviceName = serviceProto.getName();
        ctx.deprecated = serviceProto.getOptions() != null && serviceProto.getOptions().getDeprecated();
        serviceProto.getMethodList().stream().filter(method -> !method.getClientStreaming() && !method.getServerStreaming()).forEach(method -> {
            ContextMethod ctxMethod = new ContextMethod();
            ctxMethod.methodName = this.lowerCaseFirst(method.getName());
            ctxMethod.inputType = protoTypeMap.toJavaTypeName(method.getInputType());
            ctxMethod.outputType = protoTypeMap.toJavaTypeName(method.getOutputType());
            ctxMethod.deprecated = method.getOptions() != null && method.getOptions().getDeprecated();
            ctx.methods.add(ctxMethod);
        });
        return ctx;
    }

    private String lowerCaseFirst(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    private String absoluteFileName(Context ctx) {
        String dir = ctx.packageName.replace('.', '/');
        if (Strings.isNullOrEmpty((String)dir)) {
            return ctx.fileName;
        }
        return dir + "/" + ctx.fileName;
    }

    private PluginProtos.CodeGeneratorResponse.File buildFile(Context context) {
        String content = this.applyTemplate("Jdk8Stub.mustache", context);
        return PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(this.absoluteFileName(context)).setContent(content).build();
    }

    private class ContextMethod {
        public String methodName;
        public String inputType;
        public String outputType;
        public boolean deprecated;

        private ContextMethod() {
        }
    }

    private class Context {
        public String fileName;
        public String protoName;
        public String packageName;
        public String className;
        public String serviceName;
        public boolean deprecated;
        public final List<ContextMethod> methods = new ArrayList<ContextMethod>();

        private Context() {
        }
    }
}

