/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.common;

import com.google.common.base.Preconditions;
import com.salesforce.reactivegrpc.common.ReactiveConsumerStreamObserver;
import com.salesforce.reactivegrpc.common.ReactivePublisherBackpressureOnReadyHandler;
import io.grpc.stub.ClientCallStreamObserver;
import org.reactivestreams.Publisher;

public abstract class ReactiveProducerConsumerStreamObserver<TRequest, TResponse>
extends ReactiveConsumerStreamObserver<TRequest, TResponse> {
    private Publisher<TRequest> rxProducer;
    private ReactivePublisherBackpressureOnReadyHandler<TRequest> onReadyHandler;

    public ReactiveProducerConsumerStreamObserver(Publisher<TRequest> rxProducer) {
        this.rxProducer = rxProducer;
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<TRequest> requestStream) {
        super.beforeStart((ClientCallStreamObserver)Preconditions.checkNotNull(requestStream));
        this.onReadyHandler = new ReactivePublisherBackpressureOnReadyHandler<TRequest>(requestStream);
    }

    public void rxSubscribe() {
        this.rxProducer.subscribe(this.onReadyHandler);
    }

    public void cancel() {
        this.onReadyHandler.cancel();
    }
}

