/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.common;

import com.google.common.base.Preconditions;
import com.salesforce.reactivegrpc.common.Consumer;
import com.salesforce.reactivegrpc.common.ReactivePublisherBackpressureOnReadyHandler;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import org.reactivestreams.Publisher;

public class ReactiveProducerStreamObserver<TRequest, TResponse>
implements StreamObserver<TResponse>,
ClientResponseObserver<TRequest, TResponse> {
    private final Publisher<TRequest> rxProducer;
    private final Consumer<TResponse> onNext;
    private final Consumer<Throwable> onError;
    private final Runnable onCompleted;
    private ReactivePublisherBackpressureOnReadyHandler<TRequest> onReadyHandler;

    public ReactiveProducerStreamObserver(Publisher<TRequest> rxProducer, Consumer<TResponse> onNext, Consumer<Throwable> onError, Runnable onCompleted) {
        this.onNext = (Consumer)Preconditions.checkNotNull(onNext);
        this.onError = (Consumer)Preconditions.checkNotNull(onError);
        this.onCompleted = (Runnable)Preconditions.checkNotNull((Object)onCompleted);
        this.rxProducer = (Publisher)Preconditions.checkNotNull(rxProducer);
    }

    public void beforeStart(ClientCallStreamObserver<TRequest> producerStream) {
        Preconditions.checkNotNull(producerStream);
        this.onReadyHandler = new ReactivePublisherBackpressureOnReadyHandler<TRequest>(producerStream);
    }

    public void rxSubscribe() {
        this.rxProducer.subscribe(this.onReadyHandler);
    }

    public void cancel() {
        this.onReadyHandler.cancel();
    }

    public void onNext(TResponse tResponse) {
        this.onNext.accept(tResponse);
    }

    public void onError(Throwable throwable) {
        this.onError.accept(throwable);
    }

    public void onCompleted() {
        this.onCompleted.run();
    }
}

