/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.common;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Runnables;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ServerCallStreamObserver;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ReactivePublisherBackpressureOnReadyHandler<T>
implements Subscriber<T>,
Runnable {
    private CallStreamObserver<T> requestStream;
    private Subscription subscription;
    private AtomicBoolean canceled = new AtomicBoolean(false);
    private CountDownLatch subscribed = new CountDownLatch(1);
    private Runnable cancelRequestStream = Runnables.doNothing();
    private final AtomicBoolean wasReady = new AtomicBoolean(false);

    public ReactivePublisherBackpressureOnReadyHandler(final ClientCallStreamObserver<T> requestStream) {
        this.requestStream = (CallStreamObserver)Preconditions.checkNotNull(requestStream);
        requestStream.setOnReadyHandler((Runnable)this);
        this.cancelRequestStream = new Runnable(){

            @Override
            public void run() {
                requestStream.cancel("Cancelled", (Throwable)Status.CANCELLED.asException());
            }
        };
    }

    public ReactivePublisherBackpressureOnReadyHandler(ServerCallStreamObserver<T> requestStream) {
        this.requestStream = (CallStreamObserver)Preconditions.checkNotNull(requestStream);
        requestStream.setOnReadyHandler((Runnable)this);
        requestStream.setOnCancelHandler(new Runnable(){

            @Override
            public void run() {
                ReactivePublisherBackpressureOnReadyHandler.this.subscription.cancel();
            }
        });
    }

    @Override
    public void run() {
        try {
            this.subscribed.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Preconditions.checkState((this.subscription != null ? 1 : 0) != 0, (Object)"onSubscribe() not yet called");
        if (!this.isCanceled() && this.requestStream.isReady() && this.wasReady.compareAndSet(false, true)) {
            this.subscription.request(1L);
        }
    }

    public void cancel() {
        this.canceled.set(true);
        if (this.subscription != null) {
            this.subscription.cancel();
            this.subscription = null;
        }
        this.cancelRequestStream.run();
    }

    public boolean isCanceled() {
        return this.canceled.get();
    }

    public void onSubscribe(Subscription subscription) {
        if (this.subscription != null) {
            subscription.cancel();
        } else {
            this.subscription = (Subscription)Preconditions.checkNotNull((Object)subscription);
            this.subscribed.countDown();
        }
    }

    public void onNext(T t) {
        if (!this.isCanceled()) {
            this.requestStream.onNext(Preconditions.checkNotNull(t));
            if (this.requestStream.isReady()) {
                this.subscription.request(1L);
            } else {
                this.wasReady.set(false);
            }
        }
    }

    public void onError(Throwable throwable) {
        this.requestStream.onError(ReactivePublisherBackpressureOnReadyHandler.prepareError((Throwable)Preconditions.checkNotNull((Object)throwable)));
    }

    public void onComplete() {
        if (!this.isCanceled()) {
            this.requestStream.onCompleted();
        }
    }

    private static Throwable prepareError(Throwable throwable) {
        if (throwable instanceof StatusException || throwable instanceof StatusRuntimeException) {
            return throwable;
        }
        return Status.fromThrowable((Throwable)throwable).asException();
    }
}

