/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.common;

import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CountDownLatch;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ReactiveStreamObserverPublisher<T>
implements Publisher<T>,
StreamObserver<T> {
    private CallStreamObserver callStreamObserver;
    private Subscriber<? super T> subscriber;
    private volatile boolean isCanceled;
    private CountDownLatch subscribed = new CountDownLatch(1);

    public ReactiveStreamObserverPublisher(CallStreamObserver callStreamObserver) {
        Preconditions.checkNotNull((Object)callStreamObserver);
        this.callStreamObserver = callStreamObserver;
        callStreamObserver.disableAutoInboundFlowControl();
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        Preconditions.checkNotNull(subscriber);
        subscriber.onSubscribe(new Subscription(){
            private static final int MAX_REQUEST_RETRIES = 20;

            public void request(long l) {
                int i = (int)Math.min(l, Integer.MAX_VALUE);
                for (int j = 0; j < 20; ++j) {
                    try {
                        ReactiveStreamObserverPublisher.this.callStreamObserver.request(i);
                        break;
                    }
                    catch (IllegalStateException ex) {
                        if (j == 19) {
                            throw ex;
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
            }

            public void cancel() {
                if (ReactiveStreamObserverPublisher.this.callStreamObserver instanceof ServerCallStreamObserver && ((ServerCallStreamObserver)ReactiveStreamObserverPublisher.this.callStreamObserver).isCancelled()) {
                    return;
                }
                ReactiveStreamObserverPublisher.this.isCanceled = true;
                if (ReactiveStreamObserverPublisher.this.callStreamObserver instanceof ClientCallStreamObserver) {
                    ((ClientCallStreamObserver)ReactiveStreamObserverPublisher.this.callStreamObserver).cancel("Client canceled request", null);
                } else {
                    ReactiveStreamObserverPublisher.this.callStreamObserver.onError((Throwable)Status.CANCELLED.withDescription("Server canceled request").asRuntimeException());
                }
            }
        });
        this.subscriber = subscriber;
        this.subscribed.countDown();
    }

    public void onNext(T value) {
        try {
            this.subscribed.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.subscriber.onNext(Preconditions.checkNotNull(value));
    }

    public void onError(Throwable t) {
        try {
            this.subscribed.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.subscriber.onError((Throwable)Preconditions.checkNotNull((Object)t));
        this.subscriber = null;
    }

    public void onCompleted() {
        try {
            this.subscribed.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.subscriber.onComplete();
        this.subscriber = null;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }
}

