/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.common;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ReactiveBackpressureChunker<T> {
    public static final int DEFAULT_CHUNK_SIZE = 16;
    private final long chunkSize;

    public ReactiveBackpressureChunker(long chunkSize) {
        this.chunkSize = chunkSize;
    }

    public Subscriber<? super T> apply(final Subscriber<? super T> downstream) {
        return new Subscriber<T>(){
            private Subscription subscription;
            private long have = 0L;
            private long want = 0L;
            private long outstanding = 0L;

            public void onSubscribe(final Subscription subscription) {
                this.subscription = subscription;
                downstream.onSubscribe(new Subscription(){

                    public void request(long r) {
                        want = want + r;
                        this.maybeRequestMore();
                    }

                    public void cancel() {
                        subscription.cancel();
                    }
                });
            }

            public void onNext(T t) {
                downstream.onNext(t);
                ++this.have;
                this.maybeRequestMore();
            }

            public void onError(Throwable throwable) {
                downstream.onError(throwable);
            }

            public void onComplete() {
                downstream.onComplete();
            }

            private void maybeRequestMore() {
                if (this.have < this.want && this.have >= this.outstanding) {
                    this.outstanding += ReactiveBackpressureChunker.this.chunkSize;
                    this.subscription.request(ReactiveBackpressureChunker.this.chunkSize);
                }
            }
        };
    }
}

