/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.common;

import com.google.common.base.Preconditions;
import com.salesforce.reactivegrpc.common.ReactiveStreamObserverPublisherClient;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import java.util.concurrent.CountDownLatch;
import org.reactivestreams.Publisher;

public abstract class ReactiveConsumerStreamObserver<TRequest, TResponse>
implements ClientResponseObserver<TRequest, TResponse> {
    private ReactiveStreamObserverPublisherClient<TResponse> publisher;
    private Publisher<TResponse> rxConsumer;
    private CountDownLatch beforeStartCalled = new CountDownLatch(1);

    public abstract Publisher<TResponse> getReactiveConsumerFromPublisher(ReactiveStreamObserverPublisherClient<TResponse> var1);

    public Publisher<TResponse> getRxConsumer() {
        try {
            this.beforeStartCalled.await();
        }
        catch (InterruptedException e) {
            throw Status.INTERNAL.withCause((Throwable)e).asRuntimeException();
        }
        return this.rxConsumer;
    }

    public void beforeStart(ClientCallStreamObserver<TRequest> requestStream) {
        this.publisher = new ReactiveStreamObserverPublisherClient((ClientCallStreamObserver)Preconditions.checkNotNull(requestStream));
        this.rxConsumer = this.getReactiveConsumerFromPublisher(this.publisher);
        this.beforeStartCalled.countDown();
    }

    public void onNext(TResponse value) {
        Preconditions.checkState((this.publisher != null ? 1 : 0) != 0, (Object)"beforeStart() not yet called");
        if (!this.publisher.isCanceled()) {
            this.publisher.onNext(Preconditions.checkNotNull(value));
        }
    }

    public void onError(Throwable throwable) {
        Preconditions.checkState((this.publisher != null ? 1 : 0) != 0, (Object)"beforeStart() not yet called");
        if (!this.publisher.isCanceled()) {
            this.publisher.onError((Throwable)Preconditions.checkNotNull((Object)throwable));
            this.publisher = null;
            this.rxConsumer = null;
        }
    }

    public void onCompleted() {
        Preconditions.checkState((this.publisher != null ? 1 : 0) != 0, (Object)"beforeStart() not yet called");
        if (!this.publisher.isCanceled()) {
            this.publisher.onCompleted();
            this.publisher = null;
            this.rxConsumer = null;
        }
    }
}

