/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.common;

import com.google.common.base.Preconditions;
import com.salesforce.reactivegrpc.common.ReactiveConsumerStreamObserver;
import com.salesforce.reactivegrpc.common.ReactivePublisherBackpressureOnReadyHandlerClient;
import io.grpc.stub.ClientCallStreamObserver;
import org.reactivestreams.Publisher;

public abstract class ReactiveProducerConsumerStreamObserver<TRequest, TResponse>
extends ReactiveConsumerStreamObserver<TRequest, TResponse> {
    private Publisher<TRequest> rxProducer;
    private ReactivePublisherBackpressureOnReadyHandlerClient<TRequest> onReadyHandler;

    public ReactiveProducerConsumerStreamObserver(Publisher<TRequest> rxProducer) {
        this.rxProducer = rxProducer;
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<TRequest> requestStream) {
        super.beforeStart((ClientCallStreamObserver)Preconditions.checkNotNull(requestStream));
        this.onReadyHandler = new ReactivePublisherBackpressureOnReadyHandlerClient<TRequest>(requestStream);
    }

    public void rxSubscribe() {
        this.rxProducer.subscribe(this.onReadyHandler);
    }

    @Override
    public void onError(Throwable throwable) {
        super.onError(throwable);
        this.rxProducer = null;
    }

    @Override
    public void onCompleted() {
        super.onCompleted();
        this.rxProducer = null;
    }

    public void cancel() {
        this.onReadyHandler.cancel();
    }
}

