/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.common;

import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.CallStreamObserver;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class ReactivePublisherBackpressureOnReadyHandlerBase<T>
implements Subscriber<T>,
Runnable {
    private CallStreamObserver<T> requestStream;
    private Subscription subscription;
    private AtomicBoolean canceled = new AtomicBoolean(false);
    private CountDownLatch subscribed = new CountDownLatch(1);
    private final AtomicBoolean wasReady = new AtomicBoolean(false);

    public ReactivePublisherBackpressureOnReadyHandlerBase(CallStreamObserver<T> requestStream) {
        this.requestStream = (CallStreamObserver)Preconditions.checkNotNull(requestStream);
        requestStream.setOnReadyHandler((Runnable)this);
    }

    @Override
    public void run() {
        try {
            this.subscribed.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Preconditions.checkState((this.subscription != null ? 1 : 0) != 0, (Object)"onSubscribe() not yet called");
        if (!this.isCanceled() && this.requestStream.isReady() && this.wasReady.compareAndSet(false, true)) {
            this.subscription.request(1L);
        }
    }

    public void cancel() {
        this.canceled.set(true);
        if (this.subscription != null) {
            this.subscription.cancel();
            this.subscription = null;
        }
    }

    public boolean isCanceled() {
        return this.canceled.get();
    }

    public void onSubscribe(Subscription subscription) {
        Preconditions.checkNotNull((Object)subscription);
        if (this.subscription != null) {
            subscription.cancel();
        } else {
            this.subscription = subscription;
            this.subscribed.countDown();
        }
    }

    public void onNext(T t) {
        Preconditions.checkNotNull(t);
        if (!this.isCanceled()) {
            try {
                this.requestStream.onNext(t);
                if (this.requestStream.isReady()) {
                    this.subscription.request(1L);
                } else {
                    this.wasReady.set(false);
                }
            }
            catch (Throwable throwable) {
                this.cancel();
                this.requestStream.onError(ReactivePublisherBackpressureOnReadyHandlerBase.prepareError(throwable));
            }
        }
    }

    public void onError(Throwable throwable) {
        if (!this.isCanceled()) {
            Preconditions.checkNotNull((Object)throwable);
            try {
                this.requestStream.onError(ReactivePublisherBackpressureOnReadyHandlerBase.prepareError(throwable));
            }
            catch (Throwable ignore) {
                this.cancel();
            }
        }
    }

    public void onComplete() {
        if (!this.isCanceled()) {
            try {
                this.requestStream.onCompleted();
            }
            catch (Throwable throwable) {
                this.cancel();
                this.requestStream.onError(ReactivePublisherBackpressureOnReadyHandlerBase.prepareError(throwable));
            }
        }
    }

    protected void cancelSubscription() {
        this.subscription.cancel();
    }

    private static Throwable prepareError(Throwable throwable) {
        if (throwable instanceof StatusException || throwable instanceof StatusRuntimeException) {
            return throwable;
        }
        return Status.fromThrowable((Throwable)throwable).asException();
    }
}

