/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.common;

import com.google.common.base.Preconditions;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CountDownLatch;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class ReactiveStreamObserverPublisherBase<T>
implements Publisher<T>,
StreamObserver<T> {
    private CallStreamObserver callStreamObserver;
    private Subscriber<? super T> subscriber;
    private volatile boolean isCanceled;
    private CountDownLatch subscribed = new CountDownLatch(1);

    public ReactiveStreamObserverPublisherBase(CallStreamObserver callStreamObserver) {
        Preconditions.checkNotNull((Object)callStreamObserver);
        this.callStreamObserver = callStreamObserver;
        callStreamObserver.disableAutoInboundFlowControl();
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        Preconditions.checkNotNull(subscriber);
        subscriber.onSubscribe((Subscription)this.createSubscription());
        this.subscriber = subscriber;
        this.subscribed.countDown();
    }

    protected abstract ReactiveStreamObserverPublisherSubscriptionBase createSubscription();

    public void onNext(T value) {
        if (!this.isCanceled()) {
            try {
                this.subscribed.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.subscriber.onNext(Preconditions.checkNotNull(value));
        }
    }

    public void onError(Throwable t) {
        if (!this.isCanceled()) {
            try {
                this.subscribed.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.subscriber.onError((Throwable)Preconditions.checkNotNull((Object)t));
            this.subscriber = null;
            this.callStreamObserver = null;
        }
    }

    public void onCompleted() {
        if (!this.isCanceled()) {
            try {
                this.subscribed.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.subscriber.onComplete();
            this.subscriber = null;
            this.callStreamObserver = null;
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    protected void cancel() {
        this.isCanceled = true;
    }

    protected void freeSubscriber() {
        this.subscriber = null;
    }

    protected abstract class ReactiveStreamObserverPublisherSubscriptionBase
    implements Subscription {
        private static final int MAX_REQUEST_RETRIES = 20;

        protected ReactiveStreamObserverPublisherSubscriptionBase() {
        }

        public void request(long l) {
            int i = (int)Math.min(l, Integer.MAX_VALUE);
            for (int j = 0; j < 20; ++j) {
                try {
                    ReactiveStreamObserverPublisherBase.this.callStreamObserver.request(i);
                    break;
                }
                catch (IllegalStateException ex) {
                    if (j == 19) {
                        throw ex;
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
    }
}

