/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactivegrpc.gen;

import com.google.common.base.Strings;
import com.google.common.html.HtmlEscapers;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.compiler.PluginProtos;
import com.salesforce.jprotoc.Generator;
import com.salesforce.jprotoc.GeneratorException;
import com.salesforce.jprotoc.ProtoTypeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class ReactiveGrpcGenerator
extends Generator {
    private static final int METHOD_NUMBER_OF_PATHS = 4;

    protected abstract String getClassPrefix();

    private String getServiceJavaDocPrefix() {
        return "    ";
    }

    private String getMethodJavaDocPrefix() {
        return "        ";
    }

    public Stream<PluginProtos.CodeGeneratorResponse.File> generate(PluginProtos.CodeGeneratorRequest request) throws GeneratorException {
        ProtoTypeMap typeMap = ProtoTypeMap.of((Collection)request.getProtoFileList());
        List<DescriptorProtos.FileDescriptorProto> protosToGenerate = request.getProtoFileList().stream().filter(protoFile -> request.getFileToGenerateList().contains((Object)protoFile.getName())).collect(Collectors.toList());
        List<ServiceContext> services = this.findServices(protosToGenerate, typeMap);
        List<PluginProtos.CodeGeneratorResponse.File> files = this.generateFiles(services);
        return files.stream();
    }

    private List<ServiceContext> findServices(List<DescriptorProtos.FileDescriptorProto> protos, ProtoTypeMap typeMap) {
        ArrayList<ServiceContext> contexts = new ArrayList<ServiceContext>();
        protos.forEach(fileProto -> {
            List locations = fileProto.getSourceCodeInfo().getLocationList();
            locations.stream().filter(location -> location.getPathCount() == 2 && location.getPath(0) == 6).forEach(location -> {
                int serviceNumber = location.getPath(1);
                ServiceContext serviceContext = this.buildServiceContext(fileProto.getService(serviceNumber), typeMap, locations, serviceNumber);
                serviceContext.javaDoc = this.getJavaDoc(this.getComments((DescriptorProtos.SourceCodeInfo.Location)location), this.getServiceJavaDocPrefix());
                serviceContext.protoName = fileProto.getName();
                serviceContext.packageName = this.extractPackageName((DescriptorProtos.FileDescriptorProto)fileProto);
                contexts.add(serviceContext);
            });
        });
        return contexts;
    }

    private String extractPackageName(DescriptorProtos.FileDescriptorProto proto) {
        String javaPackage;
        DescriptorProtos.FileOptions options = proto.getOptions();
        if (options != null && !Strings.isNullOrEmpty((String)(javaPackage = options.getJavaPackage()))) {
            return javaPackage;
        }
        return Strings.nullToEmpty((String)proto.getPackage());
    }

    private ServiceContext buildServiceContext(DescriptorProtos.ServiceDescriptorProto serviceProto, ProtoTypeMap typeMap, List<DescriptorProtos.SourceCodeInfo.Location> locations, int serviceNumber) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.fileName = this.getClassPrefix() + serviceProto.getName() + "Grpc.java";
        serviceContext.className = this.getClassPrefix() + serviceProto.getName() + "Grpc";
        serviceContext.serviceName = serviceProto.getName();
        serviceContext.deprecated = serviceProto.getOptions() != null && serviceProto.getOptions().getDeprecated();
        locations.stream().filter(location -> location.getPathCount() == 4 && location.getPath(0) == 6 && location.getPath(1) == serviceNumber && location.getPath(2) == 2).forEach(location -> {
            int methodNumber = location.getPath(3);
            MethodContext methodContext = this.buildMethodContext(serviceProto.getMethod(methodNumber), typeMap);
            methodContext.methodNumber = methodNumber;
            methodContext.javaDoc = this.getJavaDoc(this.getComments((DescriptorProtos.SourceCodeInfo.Location)location), this.getMethodJavaDocPrefix());
            serviceContext.methods.add(methodContext);
        });
        return serviceContext;
    }

    private MethodContext buildMethodContext(DescriptorProtos.MethodDescriptorProto methodProto, ProtoTypeMap typeMap) {
        MethodContext methodContext = new MethodContext();
        methodContext.methodName = this.lowerCaseFirst(methodProto.getName());
        methodContext.inputType = typeMap.toJavaTypeName(methodProto.getInputType());
        methodContext.outputType = typeMap.toJavaTypeName(methodProto.getOutputType());
        methodContext.deprecated = methodProto.getOptions() != null && methodProto.getOptions().getDeprecated();
        methodContext.isManyInput = methodProto.getClientStreaming();
        methodContext.isManyOutput = methodProto.getServerStreaming();
        if (!methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.reactiveCallsMethodName = "oneToOne";
            methodContext.grpcCallsMethodName = "asyncUnaryCall";
        }
        if (!methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.reactiveCallsMethodName = "oneToMany";
            methodContext.grpcCallsMethodName = "asyncServerStreamingCall";
        }
        if (methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.reactiveCallsMethodName = "manyToOne";
            methodContext.grpcCallsMethodName = "asyncClientStreamingCall";
        }
        if (methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.reactiveCallsMethodName = "manyToMany";
            methodContext.grpcCallsMethodName = "asyncBidiStreamingCall";
        }
        return methodContext;
    }

    private String lowerCaseFirst(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    private List<PluginProtos.CodeGeneratorResponse.File> generateFiles(List<ServiceContext> services) {
        return services.stream().map(this::buildFile).collect(Collectors.toList());
    }

    private PluginProtos.CodeGeneratorResponse.File buildFile(ServiceContext context) {
        String content = this.applyTemplate(this.getClassPrefix() + "Stub.mustache", context);
        return PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(this.absoluteFileName(context)).setContent(content).build();
    }

    private String absoluteFileName(ServiceContext ctx) {
        String dir = ctx.packageName.replace('.', '/');
        if (Strings.isNullOrEmpty((String)dir)) {
            return ctx.fileName;
        }
        return dir + "/" + ctx.fileName;
    }

    private String getComments(DescriptorProtos.SourceCodeInfo.Location location) {
        return location.getLeadingComments().isEmpty() ? location.getTrailingComments() : location.getLeadingComments();
    }

    private String getJavaDoc(String comments, String prefix) {
        if (!comments.isEmpty()) {
            StringBuilder builder = new StringBuilder("/**\n").append(prefix).append(" * <pre>\n");
            Arrays.stream(HtmlEscapers.htmlEscaper().escape(comments).split("\n")).forEach(line -> builder.append(prefix).append(" * ").append((String)line).append("\n"));
            builder.append(prefix).append(" * <pre>\n").append(prefix).append(" */");
            return builder.toString();
        }
        return null;
    }

    private class MethodContext {
        public String methodName;
        public String inputType;
        public String outputType;
        public boolean deprecated;
        public boolean isManyInput;
        public boolean isManyOutput;
        public String reactiveCallsMethodName;
        public String grpcCallsMethodName;
        public int methodNumber;
        public String javaDoc;

        private MethodContext() {
        }

        public String methodNameUpperUnderscore() {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.methodName.length(); ++i) {
                char c = this.methodName.charAt(i);
                s.append(Character.toUpperCase(c));
                if (i >= this.methodName.length() - 1 || !Character.isLowerCase(c) || !Character.isUpperCase(this.methodName.charAt(i + 1))) continue;
                s.append('_');
            }
            return s.toString();
        }

        public String methodNamePascalCase() {
            String mn = this.methodName.replace("_", "");
            return String.valueOf(Character.toUpperCase(mn.charAt(0))) + mn.substring(1);
        }

        public String methodNameCamelCase() {
            String mn = this.methodName.replace("_", "");
            return String.valueOf(Character.toLowerCase(mn.charAt(0))) + mn.substring(1);
        }
    }

    private class ServiceContext {
        public String fileName;
        public String protoName;
        public String packageName;
        public String className;
        public String serviceName;
        public boolean deprecated;
        public String javaDoc;
        public List<MethodContext> methods = new ArrayList<MethodContext>();

        private ServiceContext() {
        }
    }
}

