/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactorgrpc.stub;

import com.google.common.util.concurrent.Runnables;
import com.salesforce.reactivegrpc.common.CancellableStreamObserver;
import com.salesforce.reactivegrpc.common.ReactiveProducerStreamObserver;
import com.salesforce.reactorgrpc.stub.ReactorConsumerStreamObserver;
import com.salesforce.reactorgrpc.stub.ReactorProducerConsumerStreamObserver;
import com.salesforce.reactorgrpc.stub.SubscribeOnlyOnceLifter;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;

public final class ClientCalls {
    private ClientCalls() {
    }

    public static <TRequest, TResponse> Mono<TResponse> oneToOne(Mono<TRequest> rxRequest, BiConsumer<TRequest, StreamObserver<TResponse>> delegate) {
        try {
            return Mono.create(emitter -> rxRequest.subscribe(request -> delegate.accept(request, new StreamObserver<TResponse>((MonoSink)emitter){
                final /* synthetic */ MonoSink val$emitter;
                {
                    this.val$emitter = monoSink;
                }

                public void onNext(TResponse tResponse) {
                    this.val$emitter.success(tResponse);
                }

                public void onError(Throwable throwable) {
                    this.val$emitter.error(throwable);
                }

                public void onCompleted() {
                }
            }), arg_0 -> ((MonoSink)emitter).error(arg_0))).transform(Operators.lift(new SubscribeOnlyOnceLifter()));
        }
        catch (Throwable throwable) {
            return Mono.error((Throwable)throwable);
        }
    }

    public static <TRequest, TResponse> Flux<TResponse> oneToMany(Mono<TRequest> rxRequest, BiConsumer<TRequest, StreamObserver<TResponse>> delegate) {
        try {
            ReactorConsumerStreamObserver consumerStreamObserver = new ReactorConsumerStreamObserver();
            rxRequest.subscribe(request -> delegate.accept((Object)request, (StreamObserver)consumerStreamObserver));
            return ((Flux)consumerStreamObserver.getRxConsumer()).transform(Operators.lift(new SubscribeOnlyOnceLifter()));
        }
        catch (Throwable throwable) {
            return Flux.error((Throwable)throwable);
        }
    }

    public static <TRequest, TResponse> Mono<TResponse> manyToOne(Flux<TRequest> rxRequest, Function<StreamObserver<TResponse>, StreamObserver<TRequest>> delegate) {
        try {
            return Mono.create(emitter -> {
                ReactiveProducerStreamObserver reactiveProducerStreamObserver = new ReactiveProducerStreamObserver((Publisher)rxRequest, arg_0 -> ((MonoSink)emitter).success(arg_0), arg_0 -> ((MonoSink)emitter).error(arg_0), Runnables.doNothing());
                delegate.apply((StreamObserver)new CancellableStreamObserver((ClientResponseObserver)reactiveProducerStreamObserver, () -> ((ReactiveProducerStreamObserver)reactiveProducerStreamObserver).cancel()));
                reactiveProducerStreamObserver.rxSubscribe();
            }).transform(Operators.lift(new SubscribeOnlyOnceLifter()));
        }
        catch (Throwable throwable) {
            return Mono.error((Throwable)throwable);
        }
    }

    public static <TRequest, TResponse> Flux<TResponse> manyToMany(Flux<TRequest> rxRequest, Function<StreamObserver<TResponse>, StreamObserver<TRequest>> delegate) {
        try {
            ReactorProducerConsumerStreamObserver consumerStreamObserver = new ReactorProducerConsumerStreamObserver(rxRequest);
            delegate.apply((StreamObserver<TResponse>)new CancellableStreamObserver(consumerStreamObserver, () -> consumerStreamObserver.cancel()));
            consumerStreamObserver.rxSubscribe();
            return ((Flux)consumerStreamObserver.getRxConsumer()).transform(Operators.lift(new SubscribeOnlyOnceLifter()));
        }
        catch (Throwable throwable) {
            return Flux.error((Throwable)throwable);
        }
    }
}

