/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactorgrpc.stub;

import com.google.common.base.Preconditions;
import com.salesforce.reactivegrpc.common.ReactivePublisherBackpressureOnReadyHandlerServer;
import com.salesforce.reactivegrpc.common.ReactiveStreamObserverPublisherServer;
import com.salesforce.reactorgrpc.stub.BackpressureChunkingLifter;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

public final class ServerCalls {
    private ServerCalls() {
    }

    public static <TRequest, TResponse> void oneToOne(TRequest request, StreamObserver<TResponse> responseObserver, Function<Mono<TRequest>, Mono<TResponse>> delegate) {
        try {
            Mono rxRequest = Mono.just(request);
            Mono rxResponse = (Mono)Preconditions.checkNotNull(delegate.apply(rxRequest));
            rxResponse.subscribe(value -> {
                if (responseObserver instanceof ServerCallStreamObserver && ((ServerCallStreamObserver)responseObserver).isCancelled()) {
                    return;
                }
                responseObserver.onNext(value);
                responseObserver.onCompleted();
            }, throwable -> responseObserver.onError(ServerCalls.prepareError(throwable)));
        }
        catch (Throwable throwable2) {
            responseObserver.onError(ServerCalls.prepareError(throwable2));
        }
    }

    public static <TRequest, TResponse> void oneToMany(TRequest request, StreamObserver<TResponse> responseObserver, Function<Mono<TRequest>, Flux<TResponse>> delegate) {
        try {
            Mono rxRequest = Mono.just(request);
            Flux rxResponse = (Flux)Preconditions.checkNotNull(delegate.apply(rxRequest));
            rxResponse.subscribe((Subscriber)new ReactivePublisherBackpressureOnReadyHandlerServer((ServerCallStreamObserver)responseObserver));
        }
        catch (Throwable throwable) {
            responseObserver.onError(ServerCalls.prepareError(throwable));
        }
    }

    public static <TRequest, TResponse> StreamObserver<TRequest> manyToOne(StreamObserver<TResponse> responseObserver, Function<Flux<TRequest>, Mono<TResponse>> delegate) {
        ReactiveStreamObserverPublisherServer streamObserverPublisher = new ReactiveStreamObserverPublisherServer((ServerCallStreamObserver)responseObserver);
        try {
            Mono rxResponse = (Mono)Preconditions.checkNotNull(delegate.apply(Flux.from((Publisher)streamObserverPublisher).transform(Operators.lift(new BackpressureChunkingLifter()))));
            rxResponse.subscribe(value -> {
                if (!streamObserverPublisher.isCanceled()) {
                    responseObserver.onNext(value);
                    responseObserver.onCompleted();
                }
            }, throwable -> {
                if (!streamObserverPublisher.isCanceled()) {
                    streamObserverPublisher.abortPendingCancel();
                    responseObserver.onError(ServerCalls.prepareError(throwable));
                }
            });
        }
        catch (Throwable throwable2) {
            responseObserver.onError(ServerCalls.prepareError(throwable2));
        }
        return streamObserverPublisher;
    }

    public static <TRequest, TResponse> StreamObserver<TRequest> manyToMany(StreamObserver<TResponse> responseObserver, Function<Flux<TRequest>, Flux<TResponse>> delegate) {
        ReactiveStreamObserverPublisherServer streamObserverPublisher = new ReactiveStreamObserverPublisherServer((ServerCallStreamObserver)responseObserver);
        try {
            Flux rxResponse = (Flux)Preconditions.checkNotNull(delegate.apply(Flux.from((Publisher)streamObserverPublisher).transform(Operators.lift(new BackpressureChunkingLifter()))));
            ReactivePublisherBackpressureOnReadyHandlerServer subscriber = new ReactivePublisherBackpressureOnReadyHandlerServer((ServerCallStreamObserver)responseObserver);
            rxResponse.subscribe(arg_0 -> ServerCalls.lambda$manyToMany$4(streamObserverPublisher, (Subscriber)subscriber, arg_0), arg_0 -> ServerCalls.lambda$manyToMany$5(streamObserverPublisher, (Subscriber)subscriber, arg_0), () -> ServerCalls.lambda$manyToMany$6(streamObserverPublisher, (Subscriber)subscriber), arg_0 -> ((Subscriber)subscriber).onSubscribe(arg_0));
        }
        catch (Throwable throwable) {
            responseObserver.onError(ServerCalls.prepareError(throwable));
        }
        return streamObserverPublisher;
    }

    private static Throwable prepareError(Throwable throwable) {
        if (throwable instanceof StatusException || throwable instanceof StatusRuntimeException) {
            return throwable;
        }
        return Status.fromThrowable((Throwable)throwable).asException();
    }

    private static /* synthetic */ void lambda$manyToMany$6(ReactiveStreamObserverPublisherServer streamObserverPublisher, Subscriber subscriber) {
        if (!streamObserverPublisher.isCanceled()) {
            subscriber.onComplete();
        }
    }

    private static /* synthetic */ void lambda$manyToMany$5(ReactiveStreamObserverPublisherServer streamObserverPublisher, Subscriber subscriber, Throwable throwable) {
        if (!streamObserverPublisher.isCanceled()) {
            streamObserverPublisher.abortPendingCancel();
            subscriber.onError(throwable);
        }
    }

    private static /* synthetic */ void lambda$manyToMany$4(ReactiveStreamObserverPublisherServer streamObserverPublisher, Subscriber subscriber, Object tResponse) {
        if (!streamObserverPublisher.isCanceled()) {
            subscriber.onNext(tResponse);
        }
    }
}

