/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactorgrpc.stub;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;

public class SubscribeOnlyOnceLifter<T>
implements BiFunction<Scannable, CoreSubscriber<? super T>, CoreSubscriber<? super T>> {
    private AtomicBoolean subscribedOnce = new AtomicBoolean(false);

    @Override
    public CoreSubscriber<? super T> apply(Scannable scannable, final CoreSubscriber<? super T> coreSubscriber) {
        return new CoreSubscriber<T>(){

            public void onSubscribe(Subscription subscription) {
                if (SubscribeOnlyOnceLifter.this.subscribedOnce.getAndSet(true)) {
                    throw new NullPointerException("You cannot directly subscribe to a gRPC service multiple times concurrently. Use Flux.share() instead.");
                }
                coreSubscriber.onSubscribe(subscription);
            }

            public void onNext(T t) {
                coreSubscriber.onNext(t);
            }

            public void onError(Throwable throwable) {
                coreSubscriber.onError(throwable);
            }

            public void onComplete() {
                coreSubscriber.onComplete();
            }
        };
    }
}

