/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactorgrpc.stub;

import com.salesforce.reactorgrpc.stub.ReactorCallOptions;
import com.salesforce.reactorgrpc.stub.ReactorClientStreamObserverAndPublisher;
import com.salesforce.reactorgrpc.stub.ReactorSubscriberAndClientProducer;
import com.salesforce.reactorgrpc.stub.SubscribeOnlyOnceLifter;
import io.grpc.CallOptions;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.function.BiConsumer;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;

public final class ClientCalls {
    private ClientCalls() {
    }

    public static <TRequest, TResponse> Mono<TResponse> oneToOne(Mono<TRequest> monoSource, BiConsumer<TRequest, StreamObserver<TResponse>> delegate, CallOptions options) {
        try {
            return Mono.create(emitter -> monoSource.subscribe(request -> delegate.accept(request, new StreamObserver<TResponse>((MonoSink)emitter){
                final /* synthetic */ MonoSink val$emitter;
                {
                    this.val$emitter = monoSink;
                }

                public void onNext(TResponse tResponse) {
                    this.val$emitter.success(tResponse);
                }

                public void onError(Throwable throwable) {
                    this.val$emitter.error(throwable);
                }

                public void onCompleted() {
                }
            }), arg_0 -> ((MonoSink)emitter).error(arg_0))).transform(Operators.lift(new SubscribeOnlyOnceLifter()));
        }
        catch (Throwable throwable) {
            return Mono.error((Throwable)throwable);
        }
    }

    public static <TRequest, TResponse> Flux<TResponse> oneToMany(Mono<TRequest> monoSource, BiConsumer<TRequest, StreamObserver<TResponse>> delegate, CallOptions options) {
        try {
            int prefetch = ReactorCallOptions.getPrefetch(options);
            int lowTide = ReactorCallOptions.getLowTide(options);
            return monoSource.flatMapMany(request -> {
                ReactorClientStreamObserverAndPublisher consumerStreamObserver = new ReactorClientStreamObserverAndPublisher(null, null, prefetch, lowTide);
                delegate.accept((Object)request, (StreamObserver)consumerStreamObserver);
                return consumerStreamObserver;
            });
        }
        catch (Throwable throwable) {
            return Flux.error((Throwable)throwable);
        }
    }

    public static <TRequest, TResponse> Mono<TResponse> manyToOne(Flux<TRequest> fluxSource, Function<StreamObserver<TResponse>, StreamObserver<TRequest>> delegate, CallOptions options) {
        try {
            ReactorSubscriberAndClientProducer subscriberAndGRPCProducer = (ReactorSubscriberAndClientProducer)fluxSource.subscribeWith(new ReactorSubscriberAndClientProducer());
            ReactorClientStreamObserverAndPublisher observerAndPublisher = new ReactorClientStreamObserverAndPublisher(s -> subscriberAndGRPCProducer.subscribe((CallStreamObserver)s), () -> ((ReactorSubscriberAndClientProducer)subscriberAndGRPCProducer).cancel());
            delegate.apply((StreamObserver<TResponse>)observerAndPublisher);
            return Flux.from(observerAndPublisher).singleOrEmpty();
        }
        catch (Throwable throwable) {
            return Mono.error((Throwable)throwable);
        }
    }

    public static <TRequest, TResponse> Flux<TResponse> manyToMany(Flux<TRequest> fluxSource, Function<StreamObserver<TResponse>, StreamObserver<TRequest>> delegate, CallOptions options) {
        try {
            int prefetch = ReactorCallOptions.getPrefetch(options);
            int lowTide = ReactorCallOptions.getLowTide(options);
            ReactorSubscriberAndClientProducer subscriberAndGRPCProducer = (ReactorSubscriberAndClientProducer)fluxSource.subscribeWith(new ReactorSubscriberAndClientProducer());
            ReactorClientStreamObserverAndPublisher observerAndPublisher = new ReactorClientStreamObserverAndPublisher(s -> subscriberAndGRPCProducer.subscribe((CallStreamObserver)s), () -> ((ReactorSubscriberAndClientProducer)subscriberAndGRPCProducer).cancel(), prefetch, lowTide);
            delegate.apply((StreamObserver<TResponse>)observerAndPublisher);
            return Flux.from(observerAndPublisher);
        }
        catch (Throwable throwable) {
            return Flux.error((Throwable)throwable);
        }
    }
}

