/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib;

import com.google.common.base.Preconditions;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.annotation.Nonnull;

public final class MoreTimestamps {
    private MoreTimestamps() {
    }

    public static Instant toInstantUtc(@Nonnull Timestamp timestamp) {
        Preconditions.checkNotNull(timestamp, "timestamp");
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    public static OffsetDateTime toOffsetDateTimeUtc(@Nonnull Timestamp timestamp) {
        Preconditions.checkNotNull(timestamp, "timestamp");
        return MoreTimestamps.toInstantUtc(timestamp).atOffset(ZoneOffset.UTC);
    }

    public static ZonedDateTime toZonedDateTimeUtc(@Nonnull Timestamp timestamp) {
        Preconditions.checkNotNull(timestamp, "timestamp");
        return MoreTimestamps.toOffsetDateTimeUtc(timestamp).toZonedDateTime();
    }

    public static Timestamp fromInstantUtc(@Nonnull Instant instant) {
        Preconditions.checkNotNull(instant, "instant");
        return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
    }

    public static Timestamp fromOffsetDateTimeUtc(@Nonnull OffsetDateTime offsetDateTime) {
        Preconditions.checkNotNull(offsetDateTime, "offsetDateTime");
        return MoreTimestamps.fromInstantUtc(offsetDateTime.toInstant());
    }

    public static Timestamp fromZonedDateTimeUtc(@Nonnull ZonedDateTime zonedDateTime) {
        Preconditions.checkNotNull(zonedDateTime, "zonedDateTime");
        return MoreTimestamps.fromOffsetDateTimeUtc(zonedDateTime.toOffsetDateTime());
    }
}

