/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib;

import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.Status;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import javax.annotation.Nullable;

public final class StaticResolver {
    public static final String DEFAULT_SCHEME = "mesh";

    private StaticResolver() {
    }

    public static NameResolverProvider provider(InetSocketAddress staticAddress) {
        return StaticResolver.provider(DEFAULT_SCHEME, staticAddress);
    }

    public static NameResolverProvider provider(String scheme, InetSocketAddress staticAddress) {
        return new StaticResolverProvider(scheme, staticAddress);
    }

    public static NameResolver.Factory factory(InetSocketAddress staticAddress) {
        return StaticResolver.factory(DEFAULT_SCHEME, staticAddress);
    }

    public static NameResolver.Factory factory(String scheme, InetSocketAddress staticAddress) {
        return new StaticResolverFactory(scheme, staticAddress);
    }

    private static class StaticResolverFactory
    extends NameResolver.Factory {
        private String scheme;
        private StaticResolverProvider provider;

        StaticResolverFactory(String scheme, InetSocketAddress staticAddress) {
            this.scheme = scheme;
            this.provider = new StaticResolverProvider(scheme, staticAddress);
        }

        @Override
        @Nullable
        public NameResolver newNameResolver(URI targetUri, Attributes params) {
            return this.provider.newNameResolver(targetUri, params);
        }

        @Override
        public String getDefaultScheme() {
            return this.scheme;
        }
    }

    private static class StaticResolverProvider
    extends NameResolverProvider {
        private final String scheme;
        private final InetSocketAddress staticAddress;

        StaticResolverProvider(String scheme, InetSocketAddress staticAddress) {
            this.scheme = scheme;
            this.staticAddress = staticAddress;
        }

        @Override
        @Nullable
        public NameResolver newNameResolver(URI targetUri, Attributes params) {
            if (this.scheme.equals(targetUri.getScheme())) {
                final String authority = targetUri.getAuthority();
                return new NameResolver(){

                    @Override
                    public String getServiceAuthority() {
                        return authority;
                    }

                    @Override
                    public void start(NameResolver.Listener listener) {
                        try {
                            listener.onAddresses(Collections.singletonList(new EquivalentAddressGroup(staticAddress)), Attributes.EMPTY);
                        }
                        catch (Throwable e) {
                            listener.onError(Status.UNKNOWN);
                        }
                    }

                    @Override
                    public void shutdown() {
                    }
                };
            }
            return null;
        }

        @Override
        protected boolean isAvailable() {
            return true;
        }

        @Override
        protected int priority() {
            return 0;
        }

        @Override
        public String getDefaultScheme() {
            return this.scheme;
        }
    }
}

