/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.context;

import com.salesforce.grpc.contrib.context.AmbientContext;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Iterator;

public class AmbientContextClientInterceptor
implements ClientInterceptor {
    private String headerPrefix;

    public AmbientContextClientInterceptor(String headerPrefix) {
        this.headerPrefix = headerPrefix;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (AmbientContext.isPresent()) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                @Override
                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    AmbientContext ctx = AmbientContext.current();
                    if (ctx != null) {
                        for (String keyString : ctx.keys()) {
                            Iterable<byte[]> values;
                            Metadata.Key<Object> key;
                            if (!keyString.startsWith(AmbientContextClientInterceptor.this.headerPrefix)) continue;
                            if (keyString.endsWith("-bin")) {
                                key = Metadata.Key.of(keyString, Metadata.BINARY_BYTE_MARSHALLER);
                                values = ctx.getAll(key);
                                if (values == null) continue;
                                for (Object value : values) {
                                    headers.put(key, value);
                                }
                                continue;
                            }
                            key = Metadata.Key.of(keyString, Metadata.ASCII_STRING_MARSHALLER);
                            values = ctx.getAll(key);
                            if (values == null) continue;
                            Iterator<byte[]> iterator = values.iterator();
                            while (iterator.hasNext()) {
                                Object value;
                                value = (String)iterator.next();
                                headers.put(key, value);
                            }
                        }
                    }
                    super.start(responseListener, headers);
                }
            };
        }
        return next.newCall(method, callOptions);
    }
}

