/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.context;

import com.salesforce.grpc.contrib.context.AmbientContext;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;

public class AmbientContextFreezeServerInterceptor
implements ServerInterceptor {
    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){

            @Override
            public void onMessage(ReqT message) {
                this.freezeAndThaw(() -> super.onMessage(message));
            }

            @Override
            public void onHalfClose() {
                this.freezeAndThaw(() -> super.onHalfClose());
            }

            @Override
            public void onCancel() {
                this.freezeAndThaw(() -> super.onCancel());
            }

            @Override
            public void onComplete() {
                this.freezeAndThaw(() -> super.onComplete());
            }

            @Override
            public void onReady() {
                this.freezeAndThaw(() -> super.onReady());
            }

            private void freezeAndThaw(Runnable delegate) {
                if (AmbientContext.isPresent()) {
                    Object freezeKey = AmbientContext.current().freeze();
                    try {
                        delegate.run();
                    }
                    finally {
                        AmbientContext.current().thaw(freezeKey);
                    }
                } else {
                    delegate.run();
                }
            }
        };
    }
}

