/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.interceptor;

import com.salesforce.servicelibs.com.google.common.base.Stopwatch;
import com.salesforce.servicelibs.io.grpc.ForwardingServerCallListener;
import com.salesforce.servicelibs.io.grpc.Metadata;
import com.salesforce.servicelibs.io.grpc.MethodDescriptor;
import com.salesforce.servicelibs.io.grpc.ServerCall;
import com.salesforce.servicelibs.io.grpc.ServerCallHandler;
import com.salesforce.servicelibs.io.grpc.ServerInterceptor;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class StopwatchServerInterceptor
implements ServerInterceptor {
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        this.logStart(call.getMethodDescriptor());
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){
            private Stopwatch stopwatch;
            {
                super(x0);
                this.stopwatch = Stopwatch.createStarted();
            }

            public void onCancel() {
                super.onCancel();
                StopwatchServerInterceptor.this.logCancel(call.getMethodDescriptor(), Duration.ofNanos(this.stopwatch.stop().elapsed(TimeUnit.NANOSECONDS)));
            }

            public void onComplete() {
                super.onComplete();
                StopwatchServerInterceptor.this.logStop(call.getMethodDescriptor(), Duration.ofNanos(this.stopwatch.stop().elapsed(TimeUnit.NANOSECONDS)));
            }
        };
    }

    protected void logStart(MethodDescriptor method) {
        System.out.println("Begin service op:" + method.getFullMethodName());
    }

    protected void logStop(MethodDescriptor method, Duration duration) {
        System.out.println("End service op:" + method.getFullMethodName() + " duration:" + duration);
    }

    protected void logCancel(MethodDescriptor method, Duration duration) {
        this.logStop(method, duration);
    }
}

