/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.jprotoc.jdk8;

import com.salesforce.jprotoc.Generator;
import com.salesforce.jprotoc.GeneratorException;
import com.salesforce.jprotoc.ProtoTypeMap;
import com.salesforce.jprotoc.ProtocPlugin;
import com.salesforce.servicelibs.com.google.common.base.Strings;
import com.salesforce.servicelibs.com.google.common.html.HtmlEscapers;
import com.salesforce.servicelibs.com.google.protobuf.DescriptorProtos;
import com.salesforce.servicelibs.com.google.protobuf.compiler.PluginProtos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Jdk8Generator
extends Generator {
    private static final String CLASS_SUFFIX = "Grpc8";
    private static final String SERVICE_JAVADOC_PREFIX = "    ";
    private static final String METHOD_JAVADOC_PREFIX = "        ";
    private static final int METHOD_NUMBER_OF_PATHS = 4;

    public static void main(String[] args) {
        if (args.length == 0) {
            ProtocPlugin.generate(new Jdk8Generator());
        } else {
            ProtocPlugin.debug(new Jdk8Generator(), args[0]);
        }
    }

    @Override
    protected List<PluginProtos.CodeGeneratorResponse.Feature> supportedFeatures() {
        return Collections.singletonList(PluginProtos.CodeGeneratorResponse.Feature.FEATURE_PROTO3_OPTIONAL);
    }

    @Override
    public List<PluginProtos.CodeGeneratorResponse.File> generateFiles(PluginProtos.CodeGeneratorRequest request) throws GeneratorException {
        ProtoTypeMap protoTypeMap = ProtoTypeMap.of(request.getProtoFileList());
        ArrayList<PluginProtos.CodeGeneratorResponse.File> files = new ArrayList<PluginProtos.CodeGeneratorResponse.File>();
        for (DescriptorProtos.FileDescriptorProto protoFile : request.getProtoFileList()) {
            if (!request.getFileToGenerateList().contains(protoFile.getName())) continue;
            for (ServiceContext ctx : this.extractContext(protoTypeMap, protoFile)) {
                files.add(this.buildFile(ctx));
            }
        }
        return files;
    }

    private List<ServiceContext> extractContext(ProtoTypeMap protoTypeMap, DescriptorProtos.FileDescriptorProto fileProto) {
        ArrayList<ServiceContext> serviceContexts = new ArrayList<ServiceContext>();
        List<DescriptorProtos.SourceCodeInfo.Location> locations = fileProto.getSourceCodeInfo().getLocationList();
        locations.stream().filter(location -> location.getPathCount() == 2 && location.getPath(0) == 6).forEach(location -> {
            int serviceNumber = location.getPath(1);
            DescriptorProtos.ServiceDescriptorProto serviceProto = fileProto.getService(serviceNumber);
            ServiceContext ctx = this.extractServiceContext(protoTypeMap, serviceProto, locations, serviceNumber);
            ctx.packageName = this.extractPackageName(fileProto);
            ctx.protoName = fileProto.getName();
            ctx.javaDoc = this.getJavaDoc(this.getComments((DescriptorProtos.SourceCodeInfo.Location)location), SERVICE_JAVADOC_PREFIX);
            serviceContexts.add(ctx);
        });
        return serviceContexts;
    }

    private String extractPackageName(DescriptorProtos.FileDescriptorProto proto) {
        String javaPackage;
        DescriptorProtos.FileOptions options = proto.getOptions();
        if (options != null && !Strings.isNullOrEmpty(javaPackage = options.getJavaPackage())) {
            return javaPackage;
        }
        return Strings.nullToEmpty(proto.getPackage());
    }

    private ServiceContext extractServiceContext(ProtoTypeMap protoTypeMap, DescriptorProtos.ServiceDescriptorProto serviceProto, List<DescriptorProtos.SourceCodeInfo.Location> locations, int serviceNumber) {
        ServiceContext ctx = new ServiceContext();
        ctx.fileName = serviceProto.getName() + CLASS_SUFFIX + ".java";
        ctx.className = serviceProto.getName() + CLASS_SUFFIX;
        ctx.serviceName = serviceProto.getName();
        ctx.deprecated = serviceProto.getOptions() != null && serviceProto.getOptions().getDeprecated();
        locations.stream().filter(location -> location.getPathCount() == 4 && location.getPath(0) == 6 && location.getPath(1) == serviceNumber && location.getPath(2) == 2).forEach(location -> {
            int methodNumber = location.getPath(3);
            DescriptorProtos.MethodDescriptorProto methodProto = serviceProto.getMethod(methodNumber);
            if (!methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
                MethodContext ctxMethod = new MethodContext();
                ctxMethod.methodName = this.lowerCaseFirst(methodProto.getName());
                ctxMethod.inputType = protoTypeMap.toJavaTypeName(methodProto.getInputType());
                ctxMethod.outputType = protoTypeMap.toJavaTypeName(methodProto.getOutputType());
                ctxMethod.deprecated = methodProto.getOptions() != null && methodProto.getOptions().getDeprecated();
                ctxMethod.javaDoc = this.getJavaDoc(this.getComments((DescriptorProtos.SourceCodeInfo.Location)location), METHOD_JAVADOC_PREFIX);
                ctx.methods.add(ctxMethod);
            }
        });
        return ctx;
    }

    private String lowerCaseFirst(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    private String absoluteFileName(ServiceContext ctx) {
        String dir = ctx.packageName.replace('.', '/');
        if (Strings.isNullOrEmpty(dir)) {
            return ctx.fileName;
        }
        return dir + "/" + ctx.fileName;
    }

    private PluginProtos.CodeGeneratorResponse.File buildFile(ServiceContext context) {
        return this.makeFile(this.absoluteFileName(context), this.applyTemplate("Jdk8Stub.mustache", context));
    }

    private String getComments(DescriptorProtos.SourceCodeInfo.Location location) {
        return location.getLeadingComments().isEmpty() ? location.getTrailingComments() : location.getLeadingComments();
    }

    private String getJavaDoc(String comments, String prefix) {
        if (!comments.isEmpty()) {
            StringBuilder builder = new StringBuilder("/**\n").append(prefix).append(" * <pre>\n");
            Arrays.stream(HtmlEscapers.htmlEscaper().escape(comments).split("\n")).forEach(line -> builder.append(prefix).append(" * ").append((String)line).append("\n"));
            builder.append(prefix).append(" * <pre>\n").append(prefix).append(" */");
            return builder.toString();
        }
        return null;
    }

    private class ServiceContext {
        public String fileName;
        public String protoName;
        public String packageName;
        public String className;
        public String serviceName;
        public boolean deprecated;
        public String javaDoc;
        public final List<MethodContext> methods = new ArrayList<MethodContext>();

        private ServiceContext() {
        }
    }

    private class MethodContext {
        public String methodName;
        public String inputType;
        public String outputType;
        public boolean deprecated;
        public String javaDoc;

        private MethodContext() {
        }
    }
}

