/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.context;

import com.salesforce.grpc.contrib.context.AmbientContext;
import com.salesforce.servicelibs.io.grpc.CallOptions;
import com.salesforce.servicelibs.io.grpc.Channel;
import com.salesforce.servicelibs.io.grpc.ClientCall;
import com.salesforce.servicelibs.io.grpc.ClientInterceptor;
import com.salesforce.servicelibs.io.grpc.ForwardingClientCall;
import com.salesforce.servicelibs.io.grpc.Metadata;
import com.salesforce.servicelibs.io.grpc.MethodDescriptor;
import java.util.Iterator;

public class AmbientContextClientInterceptor
implements ClientInterceptor {
    private String headerPrefix;

    public AmbientContextClientInterceptor(String headerPrefix) {
        this.headerPrefix = headerPrefix;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (AmbientContext.isPresent()) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    AmbientContext ctx = AmbientContext.current();
                    if (ctx != null) {
                        for (String keyString : ctx.keys()) {
                            Iterable values;
                            Metadata.Key key;
                            if (!keyString.startsWith(AmbientContextClientInterceptor.this.headerPrefix)) continue;
                            if (keyString.endsWith("-bin")) {
                                key = Metadata.Key.of((String)keyString, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
                                values = ctx.getAll(key);
                                if (values == null) continue;
                                for (Object value : values) {
                                    headers.put(key, value);
                                }
                                continue;
                            }
                            key = Metadata.Key.of((String)keyString, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                            values = ctx.getAll(key);
                            if (values == null) continue;
                            Iterator iterator = values.iterator();
                            while (iterator.hasNext()) {
                                Object value;
                                value = (String)iterator.next();
                                headers.put(key, value);
                            }
                        }
                    }
                    super.start(responseListener, headers);
                }
            };
        }
        return next.newCall(method, callOptions);
    }
}

