/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.jprotoc;

import com.salesforce.jprotoc.Generator;
import com.salesforce.jprotoc.ProtocPlugin;
import com.salesforce.servicelibs.com.google.common.base.Preconditions;
import com.salesforce.servicelibs.com.google.common.io.Files;
import com.salesforce.servicelibs.com.google.protobuf.ExtensionRegistry;
import com.salesforce.servicelibs.com.google.protobuf.ExtensionRegistryLite;
import com.salesforce.servicelibs.com.google.protobuf.GeneratedMessage;
import com.salesforce.servicelibs.com.google.protobuf.compiler.PluginProtos;
import com.salesforce.servicelibs.javax.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class ProtocPluginTesting {
    public static final String MAVEN_DUMP_PATH = "target/generated-test-sources/protobuf/dump/descriptor_dump";

    private ProtocPluginTesting() {
    }

    public static PluginProtos.CodeGeneratorResponse test(@Nonnull Generator generator, @Nonnull String dumpPath) throws IOException {
        Preconditions.checkNotNull(generator, "generator");
        return ProtocPluginTesting.test(Collections.singletonList(generator), dumpPath);
    }

    public static PluginProtos.CodeGeneratorResponse test(@Nonnull List<Generator> generators, @Nonnull String dumpPath) throws IOException {
        return ProtocPluginTesting.test(generators, Collections.emptyList(), dumpPath);
    }

    public static PluginProtos.CodeGeneratorResponse test(@Nonnull List<Generator> generators, List<GeneratedMessage.GeneratedExtension> extensions, @Nonnull String dumpPath) throws IOException {
        Preconditions.checkNotNull(generators, "generators");
        Preconditions.checkArgument(!generators.isEmpty(), "generators.isEmpty()");
        Preconditions.checkNotNull(extensions, "extensions");
        Preconditions.checkNotNull(dumpPath, "dumpPath");
        ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();
        for (GeneratedMessage.GeneratedExtension extension : extensions) {
            extensionRegistry.add(extension);
        }
        byte[] generatorRequestBytes = Files.toByteArray(new File(dumpPath));
        PluginProtos.CodeGeneratorRequest request = PluginProtos.CodeGeneratorRequest.parseFrom(generatorRequestBytes, (ExtensionRegistryLite)extensionRegistry);
        return ProtocPlugin.generate(generators, request);
    }
}

